/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.abilities.bossbars;

import com.wynntils.core.WynntilsMod;
import com.wynntils.handlers.bossbar.TrackedBar;
import com.wynntils.models.abilities.type.OphanimOrb;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;

public class OphanimBar
extends TrackedBar {
    private static final Pattern OPHANIM_PATTERN = Pattern.compile("^\u00a7710s Healed: \u00a7f(?<healed>\\d+)% \u00a7[3468]\\[(?<orbs>((\u00a7[bce7])?\u23fa){0,7})(\u00a7[3468])?\\]$");
    private static final Pattern ORB_PATTERN = Pattern.compile("(?<color>\u00a7[bce7])?\u23fa");
    private int healed = 0;
    private final List<OphanimOrb> orbs = new ArrayList<OphanimOrb>();

    public OphanimBar() {
        super(OPHANIM_PATTERN);
    }

    public int getHealed() {
        return this.healed;
    }

    public List<OphanimOrb> getOrbs() {
        return Collections.unmodifiableList(this.orbs);
    }

    @Override
    protected void reset() {
        super.reset();
        this.orbs.clear();
    }

    @Override
    public void onUpdateName(Matcher match) {
        this.healed = Integer.parseInt(match.group("healed"));
        this.orbs.clear();
        Matcher orbMatcher = ORB_PATTERN.matcher(match.group("orbs"));
        OphanimOrb.HealthState healthState = null;
        int start = 0;
        while (orbMatcher.find(start)) {
            String colorCode = orbMatcher.group("color");
            if (colorCode != null) {
                healthState = OphanimOrb.HealthState.fromColor(ChatFormatting.getByCode((char)colorCode.charAt(1)));
            }
            if (healthState == null) {
                WynntilsMod.warn("Error parsing Ophanim Orbs in string " + match.group("orbs"));
                this.orbs.clear();
                return;
            }
            this.orbs.add(new OphanimOrb(healthState));
            start = orbMatcher.end();
        }
    }

    @Override
    public void onUpdateProgress(float progress) {
        this.updateValue((int)(progress * 100.0f), 100);
    }
}

