/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.activities.discoveries;

import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.activities.type.ActivityInfo;
import com.wynntils.models.activities.type.ActivityStatus;
import com.wynntils.models.activities.type.DiscoveryType;
import com.wynntils.utils.mc.ComponentUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public record DiscoveryInfo(String name, DiscoveryType type, String description, int minLevel, boolean discovered, List<String> requirements, List<Component> displayLore) {
    public DiscoveryInfo(String name, DiscoveryType type, String description, int minLevel, boolean discovered) {
        this(name, type, description, minLevel, discovered, List.of(), DiscoveryInfo.generateLore(name, type, description, minLevel, discovered));
    }

    public static DiscoveryInfo fromActivityInfo(ActivityInfo activityInfo) {
        return new DiscoveryInfo(activityInfo.name(), DiscoveryType.fromActivityType(activityInfo.type()), activityInfo.description().orElse(StyledText.EMPTY).getString(), activityInfo.requirements().level().key(), activityInfo.status() == ActivityStatus.COMPLETED);
    }

    private static List<Component> generateLore(String name, DiscoveryType type, String description, int minLevel, boolean discovered) {
        ArrayList<Component> lore = new ArrayList<Component>();
        lore.add((Component)Component.literal((String)name).withStyle(type.getColor()).withStyle(ChatFormatting.BOLD));
        if (Models.CombatXp.getCombatLevel().current() >= minLevel) {
            lore.add((Component)Component.literal((String)"\u2714").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)" Combat Lv. Min: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.valueOf(minLevel)).withStyle(ChatFormatting.WHITE))));
        } else {
            lore.add((Component)Component.literal((String)"\u2718").withStyle(ChatFormatting.RED).append((Component)Component.literal((String)" Combat Lv. Min: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.valueOf(minLevel)).withStyle(ChatFormatting.WHITE))));
        }
        lore.add((Component)Component.empty());
        if (discovered) {
            lore.add((Component)Component.literal((String)"Discovered").withStyle(ChatFormatting.GREEN));
        } else {
            lore.add((Component)Component.literal((String)"Not Discovered").withStyle(ChatFormatting.RED));
        }
        if (!description.isEmpty()) {
            lore.add((Component)Component.empty());
            lore.addAll(ComponentUtils.wrapTooltips(List.of(Component.literal((String)description).withStyle(ChatFormatting.GRAY)), 300));
        }
        return lore;
    }
}

