/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.activities.type;

import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public enum ActivityStatus {
    STARTED(Pattern.compile(String.valueOf(ChatFormatting.GREEN) + "Currently (in progress|tracking)"), Pattern.compile(String.valueOf(ChatFormatting.GREEN) + "Event has started")),
    AVAILABLE(Pattern.compile(String.valueOf(ChatFormatting.YELLOW) + "Can be .+"), Pattern.compile(String.valueOf(ChatFormatting.GREEN) + "Event starting in .+")),
    UNAVAILABLE(Pattern.compile(String.valueOf(ChatFormatting.RED) + "Cannot be .+"), Pattern.compile(String.valueOf(ChatFormatting.RED) + "(Event is not active|You do not meet the requirements)")),
    COMPLETED(Pattern.compile(String.valueOf(ChatFormatting.GREEN) + "Already completed"), null);

    private final Pattern statusPattern;
    private final Pattern worldEventPattern;

    private ActivityStatus(Pattern statusMessage, Pattern worldEventPattern) {
        this.statusPattern = statusMessage;
        this.worldEventPattern = worldEventPattern;
    }

    public static ActivityStatus from(String statusLine) {
        for (ActivityStatus status : ActivityStatus.values()) {
            if (!status.statusPattern.matcher(statusLine).matches()) continue;
            return status;
        }
        return null;
    }

    public static ActivityStatus fromWorldEvent(String statusMessage) {
        for (ActivityStatus status : ActivityStatus.values()) {
            if (status.worldEventPattern == null || !status.worldEventPattern.matcher(statusMessage).matches()) continue;
            return status;
        }
        return null;
    }

    public Component getQuestStateComponent() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Component.literal((String)"Started...").withStyle(ChatFormatting.YELLOW);
            case 1 -> Component.literal((String)"Can start...").withStyle(ChatFormatting.YELLOW);
            case 2 -> Component.literal((String)"Cannot start...").withStyle(ChatFormatting.RED);
            case 3 -> Component.literal((String)"Completed!").withStyle(ChatFormatting.GREEN);
        };
    }
}

