/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.activities.type;

import com.wynntils.models.activities.type.ActivityType;
import net.minecraft.ChatFormatting;

public enum DiscoveryType {
    TERRITORY(ChatFormatting.WHITE),
    WORLD(ChatFormatting.YELLOW),
    SECRET(ChatFormatting.AQUA);

    private final ChatFormatting color;

    private DiscoveryType(ChatFormatting color) {
        this.color = color;
    }

    public static DiscoveryType fromActivityType(ActivityType activityType) {
        return switch (activityType) {
            case ActivityType.WORLD_DISCOVERY -> WORLD;
            case ActivityType.TERRITORIAL_DISCOVERY -> TERRITORY;
            case ActivityType.SECRET_DISCOVERY -> SECRET;
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)activityType));
        };
    }

    public ChatFormatting getColor() {
        return this.color;
    }
}

