/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.combat;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Model;
import com.wynntils.handlers.labels.event.LabelIdentifiedEvent;
import com.wynntils.handlers.labels.event.LabelsRemovedEvent;
import com.wynntils.handlers.labels.type.LabelInfo;
import com.wynntils.models.combat.bossbar.DamageBar;
import com.wynntils.models.combat.label.DamageLabelInfo;
import com.wynntils.models.combat.label.DamageLabelParser;
import com.wynntils.models.combat.label.KillLabelInfo;
import com.wynntils.models.combat.label.KillLabelParser;
import com.wynntils.models.combat.type.DamageDealtEvent;
import com.wynntils.models.combat.type.FocusedDamageEvent;
import com.wynntils.models.combat.type.KillCreditType;
import com.wynntils.models.combat.type.MobElementals;
import com.wynntils.models.stats.type.DamageType;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.utils.type.CappedValue;
import com.wynntils.utils.type.TimedSet;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.neoforged.bus.api.SubscribeEvent;

public final class CombatModel
extends Model {
    private static final long FOCUSED_MOB_INVALIDATION_DELAY = 1000L;
    private final DamageBar damageBar = new DamageBar();
    private final TimedSet<Long> areaDamageSet = new TimedSet(60L, TimeUnit.SECONDS, true);
    private final Map<Integer, Map<DamageType, Long>> liveDamageInfo = new HashMap<Integer, Map<DamageType, Long>>();
    private final TimedSet<KillCreditType> killSet = new TimedSet(60L, TimeUnit.SECONDS, true);
    private String focusedMobName = "";
    private MobElementals focusedMobElementals = MobElementals.EMPTY;
    private long focusedMobHealth;
    private CappedValue focusedMobHealthPercent = CappedValue.EMPTY;
    private long focusedMobExpiryTime = -1L;
    private long lastDamageDealtTimestamp;
    private long lastSharedKillTimestamp;
    private long lastSelfKillTimestamp;

    public CombatModel() {
        super(List.of());
        Handlers.BossBar.registerBar(this.damageBar);
        Handlers.Label.registerParser(new DamageLabelParser());
        Handlers.Label.registerParser(new KillLabelParser());
    }

    @SubscribeEvent
    public void onLabelIdentified(LabelIdentifiedEvent event) {
        LabelInfo labelInfo = event.getLabelInfo();
        if (labelInfo instanceof DamageLabelInfo) {
            Map<DamageType, Long> damages;
            DamageLabelInfo damageLabelInfo = (DamageLabelInfo)labelInfo;
            int id = damageLabelInfo.getEntity().getId();
            if (this.liveDamageInfo.containsKey(id)) {
                Map<DamageType, Long> oldDamages = this.liveDamageInfo.get(id);
                Map<DamageType, Long> newDamages = damageLabelInfo.getDamages();
                this.liveDamageInfo.put(id, new EnumMap<DamageType, Long>(newDamages));
                for (Map.Entry<DamageType, Long> entry : newDamages.entrySet()) {
                    DamageType type = entry.getKey();
                    long newValue = entry.getValue();
                    if (!oldDamages.containsKey((Object)type)) continue;
                    long oldValue = oldDamages.get((Object)type);
                    newDamages.put(type, newValue - oldValue);
                }
                damages = newDamages;
            } else {
                damages = damageLabelInfo.getDamages();
                this.liveDamageInfo.put(id, damages);
            }
            long damageSum = damages.values().stream().mapToLong(d -> d).sum();
            this.areaDamageSet.put(damageSum);
            WynntilsMod.postEvent(new DamageDealtEvent(damages));
            this.lastDamageDealtTimestamp = System.currentTimeMillis();
        } else {
            labelInfo = event.getLabelInfo();
            if (labelInfo instanceof KillLabelInfo) {
                KillLabelInfo killLabelInfo = (KillLabelInfo)labelInfo;
                this.killSet.put(killLabelInfo.getKillCredit());
                if (killLabelInfo.getKillCredit() == KillCreditType.SELF) {
                    this.lastSelfKillTimestamp = System.currentTimeMillis();
                } else if (killLabelInfo.getKillCredit() == KillCreditType.SHARED) {
                    this.lastSharedKillTimestamp = System.currentTimeMillis();
                }
            }
        }
    }

    @SubscribeEvent
    public void onLabelsRemoved(LabelsRemovedEvent event) {
        event.getRemovedLabels().forEach(labelInfo -> this.liveDamageInfo.remove(labelInfo.getEntity().getId()));
    }

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent event) {
        this.areaDamageSet.clear();
        this.focusedMobName = "";
        this.focusedMobHealth = 0L;
        this.focusedMobElementals = MobElementals.EMPTY;
        this.focusedMobHealthPercent = CappedValue.EMPTY;
        this.focusedMobExpiryTime = -1L;
        this.lastDamageDealtTimestamp = 0L;
        this.liveDamageInfo.clear();
    }

    public long getLastDamageDealtTimestamp() {
        return this.lastDamageDealtTimestamp;
    }

    public void setLastDamageDealtTimestamp(long lastDamageDealtTimestamp) {
        this.lastDamageDealtTimestamp = lastDamageDealtTimestamp;
    }

    public long getLastKillTimestamp(boolean includeShared) {
        return includeShared ? Math.max(this.lastSelfKillTimestamp, this.lastSharedKillTimestamp) : this.lastSelfKillTimestamp;
    }

    public void updateFocusedMob(String name, MobElementals elementals, long health) {
        this.focusedMobName = name;
        this.focusedMobElementals = elementals;
        this.focusedMobHealth = health;
        WynntilsMod.postEvent(new FocusedDamageEvent.MobFocused(name, elementals, health));
    }

    public String getFocusedMobName() {
        this.checkFocusedMobValidity();
        return this.focusedMobName;
    }

    public MobElementals getFocusedMobElementals() {
        this.checkFocusedMobValidity();
        return this.focusedMobElementals;
    }

    public long getFocusedMobHealth() {
        this.checkFocusedMobValidity();
        return this.focusedMobHealth;
    }

    public void updateFocusedMobHealth(long newHealth) {
        long oldHealth = this.focusedMobHealth;
        this.focusedMobHealth = newHealth;
        WynntilsMod.postEvent(new FocusedDamageEvent.MobDamaged(this.focusedMobName, this.focusedMobElementals, newHealth, oldHealth));
    }

    public CappedValue getFocusedMobHealthPercent() {
        this.checkFocusedMobValidity();
        return this.focusedMobHealthPercent;
    }

    public void updateFocusedMobHealthPercent(CappedValue newHealthPercent) {
        this.focusedMobHealthPercent = newHealthPercent;
    }

    public long getAreaDamagePerSecond() {
        return this.areaDamageSet.getEntries().stream().filter(timedEntry -> System.currentTimeMillis() - timedEntry.getCreation() <= 1000L).mapToLong(TimedSet.TimedEntry::getEntry).sum();
    }

    public double getAverageAreaDamagePerSecond(int seconds) {
        return (double)this.areaDamageSet.getEntries().stream().filter(timedEntry -> System.currentTimeMillis() - timedEntry.getCreation() <= (long)seconds * 1000L).mapToLong(TimedSet.TimedEntry::getEntry).sum() / (double)seconds;
    }

    public double getTotalAreaDamageOverSeconds(int seconds) {
        return this.areaDamageSet.getEntries().stream().filter(timedEntry -> System.currentTimeMillis() - timedEntry.getCreation() <= (long)seconds * 1000L).mapToLong(TimedSet.TimedEntry::getEntry).sum();
    }

    public int getKillsPerMinute(boolean includeShared) {
        return this.killSet.getEntries().stream().filter(creditType -> includeShared || creditType.getEntry() == KillCreditType.SELF).filter(timedEntry -> System.currentTimeMillis() - timedEntry.getCreation() <= 60000L).toList().size();
    }

    public void checkFocusedMobValidity() {
        if (this.focusedMobExpiryTime >= 0L && System.currentTimeMillis() >= this.focusedMobExpiryTime) {
            this.focusedMobName = "";
            this.focusedMobElementals = MobElementals.EMPTY;
            this.focusedMobHealth = 0L;
            this.focusedMobHealthPercent = CappedValue.EMPTY;
            this.focusedMobExpiryTime = -1L;
        }
    }

    public void invalidateFocusedMob() {
        this.focusedMobExpiryTime = System.currentTimeMillis() + 1000L;
    }

    public void revalidateFocusedMob() {
        this.focusedMobExpiryTime = -1L;
    }
}

