/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.guild.profile;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.wynntils.utils.colors.CustomColor;
import java.lang.reflect.Type;

public record GuildProfile(String prefix, String name, CustomColor color) {

    public static class GuildProfileDeserializer
    implements JsonDeserializer<GuildProfile> {
        public GuildProfile deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            CustomColor color;
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if (jsonObject.get("_id").isJsonNull() || jsonObject.get("prefix").isJsonNull()) {
                return null;
            }
            String name = jsonObject.getAsJsonPrimitive("_id").getAsString();
            String prefix = jsonObject.getAsJsonPrimitive("prefix").getAsString();
            String colorString = jsonObject.has("color") ? jsonObject.getAsJsonPrimitive("color").getAsString() : "";
            CustomColor customColor = color = colorString.isBlank() ? CustomColor.colorForStringHash(name) : CustomColor.fromHexString(colorString);
            if (color == CustomColor.NONE) {
                color = CustomColor.colorForStringHash(name);
            }
            return new GuildProfile(prefix, name, color);
        }
    }
}

