/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.annotators.gui;

import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.item.GuiItemAnnotator;
import com.wynntils.handlers.item.ItemAnnotation;
import com.wynntils.models.items.items.gui.AbilityTreeItem;
import com.wynntils.utils.mc.LoreUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.world.item.ItemStack;

public final class AbilityTreeAnnotator
implements GuiItemAnnotator {
    private static final StyledText COMPASS_ABILITY_POINTS_NAME = StyledText.fromString("\u00a7b\u00a7lAbility Tree");
    private static final Pattern COMPASS_ABILITY_POINTS_PATTERN = Pattern.compile("^\u00a73\u2726 Unused Points: \u00a7f(\\d+)$");
    private static final StyledText TREE_ABILITY_POINTS_NAME = StyledText.fromString("\u00a7#82eff4ff\u00a7lAbility Points");
    private static final Pattern TREE_ABILITY_POINTS_PATTERN = Pattern.compile("^\u00a7b\u2726 Available Points: \u00a7f(\\d+)\u00a77/\\d+$");

    @Override
    public ItemAnnotation getAnnotation(ItemStack itemStack, StyledText name) {
        if (name.equals(COMPASS_ABILITY_POINTS_NAME)) {
            Matcher matcher = LoreUtils.matchLoreLine(itemStack, 3, COMPASS_ABILITY_POINTS_PATTERN);
            if (!matcher.matches()) {
                return null;
            }
            int count = Integer.parseInt(matcher.group(1));
            return new AbilityTreeItem(count);
        }
        if (name.equals(TREE_ABILITY_POINTS_NAME)) {
            Matcher matcher = LoreUtils.matchLoreLine(itemStack, 3, TREE_ABILITY_POINTS_PATTERN);
            if (!matcher.matches()) {
                return null;
            }
            int count = Integer.parseInt(matcher.group(1));
            return new AbilityTreeItem(count);
        }
        return null;
    }
}

