/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.items.game;

import com.wynntils.models.character.type.ClassType;
import com.wynntils.models.gear.type.GearTier;
import com.wynntils.models.gear.type.GearType;
import com.wynntils.models.items.items.game.GameItem;
import com.wynntils.models.items.properties.GearTierItemProperty;
import com.wynntils.models.items.properties.GearTypeItemProperty;
import com.wynntils.models.items.properties.IdentifiableItemProperty;
import com.wynntils.models.items.properties.LeveledItemProperty;
import com.wynntils.models.items.properties.RerollableItemProperty;
import com.wynntils.models.rewards.type.CharmInfo;
import com.wynntils.models.rewards.type.CharmInstance;
import com.wynntils.models.stats.type.StatActualValue;
import com.wynntils.models.stats.type.StatPossibleValues;
import com.wynntils.models.stats.type.StatType;
import com.wynntils.utils.type.Pair;
import com.wynntils.utils.type.RangedValue;
import java.util.List;
import java.util.Optional;

public class CharmItem
extends GameItem
implements GearTierItemProperty,
GearTypeItemProperty,
RerollableItemProperty,
LeveledItemProperty,
IdentifiableItemProperty<CharmInfo, CharmInstance> {
    private final CharmInfo charmInfo;
    private final CharmInstance charmInstance;

    public CharmItem(CharmInfo charmInfo, CharmInstance charmInstance) {
        this.charmInfo = charmInfo;
        this.charmInstance = charmInstance;
    }

    @Override
    public GearType getGearType() {
        return GearType.CHARM;
    }

    @Override
    public CharmInfo getItemInfo() {
        return this.charmInfo;
    }

    @Override
    public Optional<CharmInstance> getItemInstance() {
        return Optional.ofNullable(this.charmInstance);
    }

    @Override
    public int getRerollCount() {
        return this.charmInstance != null ? this.charmInstance.rerolls() : 0;
    }

    @Override
    public GearTier getGearTier() {
        return this.charmInfo.tier();
    }

    @Override
    public String getName() {
        return this.charmInfo.name();
    }

    @Override
    public ClassType getRequiredClass() {
        return ClassType.NONE;
    }

    @Override
    public List<StatType> getVariableStats() {
        return this.charmInfo.variableStats().stream().map(Pair::a).toList();
    }

    @Override
    public int getLevel() {
        return this.charmInfo.requirements().level();
    }

    @Override
    public List<StatActualValue> getIdentifications() {
        if (this.charmInstance == null) {
            return List.of();
        }
        return this.charmInstance.identifications();
    }

    @Override
    public List<StatPossibleValues> getPossibleValues() {
        return this.charmInfo.variableStats().stream().map(Pair::b).toList();
    }

    @Override
    public RangedValue getIdentificationLevelRange() {
        return this.charmInfo.requirements().workingLevelRange();
    }

    @Override
    public boolean hasOverallValue() {
        return this.charmInstance != null && this.charmInstance.hasOverallValue();
    }

    @Override
    public boolean isPerfect() {
        return this.charmInstance != null && this.charmInstance.isPerfect();
    }

    @Override
    public boolean isDefective() {
        return this.charmInstance != null && this.charmInstance.isDefective();
    }

    @Override
    public float getOverallPercentage() {
        return this.charmInstance != null ? this.charmInstance.getOverallPercentage() : 0.0f;
    }

    @Override
    public String toString() {
        return "CharmItem{charmInfo=" + String.valueOf(this.charmInfo) + ", charmInstance=" + String.valueOf(this.charmInstance) + "}";
    }
}

