/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.lootrun.markers;

import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.features.combat.CustomLootrunBeaconsFeature;
import com.wynntils.models.lootrun.beacons.LootrunBeaconKind;
import com.wynntils.models.lootrun.type.TaskPrediction;
import com.wynntils.models.marker.type.MarkerInfo;
import com.wynntils.models.marker.type.MarkerProvider;
import com.wynntils.models.marker.type.StaticLocationSupplier;
import com.wynntils.services.map.pois.MarkerPoi;
import com.wynntils.utils.EnumUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.type.PoiLocation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class LootrunBeaconMarkerProvider
implements MarkerProvider<MarkerPoi> {
    private List<MarkerInfo> taskMarkers = new ArrayList<MarkerInfo>();
    private List<MarkerPoi> pois = new ArrayList<MarkerPoi>();

    public void reloadTaskMarkers() {
        ArrayList<MarkerInfo> newTaskMarkers = new ArrayList<MarkerInfo>();
        for (Map.Entry<LootrunBeaconKind, TaskPrediction> entry : Models.Lootrun.getBeacons().entrySet()) {
            newTaskMarkers.add(new MarkerInfo(EnumUtils.toNiceString(entry.getKey()) + " Beacon", new StaticLocationSupplier(entry.getValue().taskLocation().location()), entry.getValue().lootrunMarker().getTaskType().getTexture(), entry.getKey().getDisplayColor(), CommonColors.WHITE, entry.getKey().getDisplayColor(), (Boolean)Managers.Feature.getFeatureInstance(CustomLootrunBeaconsFeature.class).showAdditionalTextInWorld.get() != false ? entry.getValue().taskLocation().name() + " - " + entry.getKey().name() : null));
        }
        this.taskMarkers = newTaskMarkers;
        ArrayList<MarkerPoi> newPois = new ArrayList<MarkerPoi>();
        for (MarkerInfo entry : this.taskMarkers) {
            newPois.add(new MarkerPoi(PoiLocation.fromLocation(entry.location()), entry.name(), entry.texture()));
        }
        this.pois = newPois;
    }

    @Override
    public Stream<MarkerInfo> getMarkerInfos() {
        return this.taskMarkers.stream();
    }

    @Override
    public Stream<MarkerPoi> getPois() {
        return this.pois.stream();
    }

    @Override
    public boolean isEnabled() {
        return Models.Lootrun.getState().isRunning() && Managers.Feature.getFeatureInstance(CustomLootrunBeaconsFeature.class).isEnabled();
    }
}

