/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.npc.label;

import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.labels.type.LabelParser;
import com.wynntils.models.npc.label.NpcLabelInfo;
import com.wynntils.utils.mc.type.Location;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.world.entity.Entity;

public class NpcLabelParser
implements LabelParser<NpcLabelInfo> {
    private static final Pattern NPC_LABEL_PATTERN = Pattern.compile("^\u00a7f(?<icon>.)\n\u00a7(?:c|d)(?<name>[a-zA-Z ]*)(?:\u00a7f)?\n\u00a77(?<description>.*)$", 32);
    private static final Pattern HOUSING_LABEL_PATTERN = Pattern.compile("^\u00a7fClick \u00a77to go to your housing plot$");
    private static final Pattern BOOTH_SHOP_LABEL_PATTERN = Pattern.compile("^(\u00a7b.*'(s)?\u00a77 Shop.*|\u00a7f\ue000 Click \u00a77to set up booth)$", 32);
    private static final Pattern SEASKIPPER_LABEL_PATTERN = Pattern.compile("^\u00a76V.S.S. Seaskipper\n\u00a77Right-click to Sail\n\u00a70\u00c0$");
    private static final Pattern LOOTRUN_MASTER_LABEL_PATTERN = Pattern.compile("\u00a7dLootrun Master\n\u00a77Start a Lootrun");

    @Override
    public NpcLabelInfo getInfo(StyledText label, Location location, Entity entity) {
        Matcher matcher = NPC_LABEL_PATTERN.matcher(label.getString());
        if (matcher.matches()) {
            return new NpcLabelInfo(label, matcher.group("name"), location.offset(0, -1, 0), entity, matcher.group("icon"), matcher.group("description"));
        }
        if (label.matches(HOUSING_LABEL_PATTERN)) {
            return new NpcLabelInfo(label, "Housing Balloon", location, entity);
        }
        if (label.matches(BOOTH_SHOP_LABEL_PATTERN)) {
            return new NpcLabelInfo(label, "Booth Shop", location.offset(0, -1, 0), entity);
        }
        if (label.matches(SEASKIPPER_LABEL_PATTERN)) {
            return new NpcLabelInfo(label, "Seaskipper", location.offset(0, -1, 0), entity);
        }
        if (label.matches(LOOTRUN_MASTER_LABEL_PATTERN)) {
            return new NpcLabelInfo(label, "Lootrun Master", location.offset(0, -1, 0), entity);
        }
        return null;
    }
}

