/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.objectives;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Model;
import com.wynntils.handlers.scoreboard.ScoreboardPart;
import com.wynntils.models.objectives.DailyObjectiveScoreboardPart;
import com.wynntils.models.objectives.GuildObjectiveScoreboardPart;
import com.wynntils.models.objectives.WynnObjective;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public final class ObjectivesModel
extends Model {
    private static final ScoreboardPart DAILY_OBJECTIVES_SCOREBOARD_PART = new DailyObjectiveScoreboardPart();
    private static final ScoreboardPart GUILD_OBJECTIVES_SCOREBOARD_PART = new GuildObjectiveScoreboardPart();
    private List<WynnObjective> personalObjectives = new ArrayList<WynnObjective>();
    private WynnObjective guildObjective = null;

    public ObjectivesModel() {
        super(List.of());
        Handlers.Scoreboard.addPart(DAILY_OBJECTIVES_SCOREBOARD_PART);
        Handlers.Scoreboard.addPart(GUILD_OBJECTIVES_SCOREBOARD_PART);
    }

    public WynnObjective getGuildObjective() {
        return this.guildObjective;
    }

    public List<WynnObjective> getPersonalObjectives() {
        return Collections.unmodifiableList(this.personalObjectives);
    }

    void resetObjectives() {
        this.guildObjective = null;
        this.personalObjectives = new ArrayList<WynnObjective>();
    }

    void updatePersonalObjective(WynnObjective parsed) {
        Optional<WynnObjective> objective = this.personalObjectives.stream().filter(wynnObjective -> wynnObjective.isSameObjective(parsed)).findFirst();
        if (objective.isEmpty()) {
            this.personalObjectives.add(parsed);
        } else {
            objective.get().setCurrentScore(parsed.getScore().current());
        }
        if (this.personalObjectives.size() > 3) {
            WynntilsMod.error("ObjectiveManager: Stored more than 3 objectives. Reset objective list.");
            this.personalObjectives.clear();
            this.personalObjectives.add(parsed);
        }
    }

    void purgePersonalObjectives(List<WynnObjective> objectives) {
        this.personalObjectives.removeIf(wynnObjective -> objectives.stream().noneMatch(other -> other.isSameObjective((WynnObjective)wynnObjective)));
    }

    void updateGuildObjective(WynnObjective parsed) {
        if (this.guildObjective != null && this.guildObjective.isSameObjective(parsed)) {
            this.guildObjective.setCurrentScore(parsed.getScore().current());
            return;
        }
        this.guildObjective = parsed;
    }

    void removeObjective(WynnObjective parsed) {
        if (this.guildObjective != null && this.guildObjective.isSameObjective(parsed)) {
            this.guildObjective = null;
            return;
        }
        this.personalObjectives.removeIf(wynnObjective -> wynnObjective.isSameObjective(parsed));
    }
}

