/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.objectives;

import com.wynntils.core.text.PartStyle;
import com.wynntils.core.text.StyledText;
import com.wynntils.utils.type.CappedValue;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class WynnObjective {
    private static final Pattern OBJECTIVE_PARSER_PATTERN = Pattern.compile("^[- ] (.*): *(\\d+)/(\\d+)$");
    private final String goal;
    private CappedValue score;
    private long updatedAt;
    private final StyledText original;
    private final boolean isGuildObjective;
    private final boolean hasEventBonus;
    public static final WynnObjective DEMO_GUILD = new WynnObjective("Slay Loot Chests", new CappedValue(5, 15), 0L, StyledText.fromString("Slay Loot Chests 5/15"), true, false);

    private WynnObjective(String goal, CappedValue score, long updatedAt, StyledText original, boolean isGuildObjective, boolean hasEventBonus) {
        this.goal = goal;
        this.score = score;
        this.updatedAt = updatedAt;
        this.original = original;
        this.isGuildObjective = isGuildObjective;
        this.hasEventBonus = hasEventBonus;
    }

    static WynnObjective parseObjectiveLine(StyledText objectiveLine, boolean isGuildObjective, boolean hasEventBonus) {
        String stripped = objectiveLine.getString(PartStyle.StyleType.NONE);
        Matcher matcher = OBJECTIVE_PARSER_PATTERN.matcher(stripped);
        String goal = null;
        int score = 0;
        int maxScore = 0;
        if (matcher.find()) {
            goal = matcher.group(1);
            try {
                score = Integer.parseInt(matcher.group(2));
                maxScore = Integer.parseInt(matcher.group(3));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new WynnObjective(goal, new CappedValue(score, maxScore), System.currentTimeMillis(), objectiveLine, isGuildObjective, hasEventBonus);
    }

    public String toString() {
        return this.goal + ": " + String.valueOf(this.score);
    }

    public String asObjectiveString() {
        return (this.hasEventBonus ? "\u2605 " : "") + this.getGoal() + ": " + String.valueOf(this.getScore());
    }

    private void updateTimestamp() {
        this.updatedAt = System.currentTimeMillis();
    }

    public boolean hasProgress() {
        return this.score.max() > 0;
    }

    public float getProgress() {
        return (float)this.score.getProgress();
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public String getGoal() {
        return this.goal;
    }

    public StyledText getOriginal() {
        return this.original;
    }

    public CappedValue getScore() {
        return this.score;
    }

    public boolean isGuildObjective() {
        return this.isGuildObjective;
    }

    public boolean isSameObjective(WynnObjective other) {
        return Objects.equals(this.getGoal(), other.getGoal()) && this.getScore().max() == other.getScore().max();
    }

    public void setCurrentScore(int newCurrentScore) {
        this.score = this.score.withCurrent(newCurrentScore);
        this.updateTimestamp();
    }
}

