/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.players;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.chat.event.ChatMessageEvent;
import com.wynntils.handlers.chat.type.MessageType;
import com.wynntils.models.players.event.FriendsEvent;
import com.wynntils.models.players.event.HadesRelationsUpdateEvent;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.models.worlds.type.WorldState;
import com.wynntils.services.hades.event.HadesEvent;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.StyledTextUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

public final class FriendsModel
extends Model {
    private static final String FRIEND_PREFIX_REGEX = "(?:\u00a7(?:a|4))?(?:\ue008\ue002|\ue001) ";
    private static final Pattern FRIEND_LIST = Pattern.compile("(?:\u00a7(?:a|4))?(?:\ue008\ue002|\ue001) .+'s? friends \\(.+\\): (.*)");
    private static final Pattern FRIEND_LIST_FAIL_1 = Pattern.compile("(?:\u00a7(?:a|4))?(?:\ue008\ue002|\ue001) We couldn't find any friends\\.");
    private static final Pattern FRIEND_LIST_FAIL_2 = Pattern.compile("(?:\u00a7(?:a|4))?(?:\ue008\ue002|\ue001) Try typing \u00a76/friend add Username\u00a7e!");
    private static final Pattern FRIEND_REMOVE_MESSAGE_PATTERN = Pattern.compile("(?:\u00a7(?:a|4))?(?:\ue008\ue002|\ue001) (.+) has been removed from your friends!");
    private static final Pattern FRIEND_ADD_MESSAGE_PATTERN = Pattern.compile("(?:\u00a7(?:a|4))?(?:\ue008\ue002|\ue001) (.+) has been added to your friends!");
    private static final Pattern ONLINE_FRIENDS_HEADER = Pattern.compile("(?:\u00a7(?:a|4))?(?:\ue008\ue002|\ue001) Online Friends:");
    private static final Pattern ONLINE_FRIEND = Pattern.compile("(?:\u00a7(?:a|4))?(?:\ue008\ue002|\ue001) \u00a72 - \u00a7a(\\w{1,16})\u00a72 \\[Server: \u00a7a([A-Z]+\\d{1,3})\u00a72]");
    private static final Pattern JOIN_PATTERN = Pattern.compile("\u00a7a(?<username>\\w{1,16})\u00a72 has logged into server \u00a7a(?<server>[A-Z]+\\d{1,3})\u00a72 as \u00a7aan? (?<class>[A-Z][a-z]+)");
    private static final Pattern LEAVE_PATTERN = Pattern.compile("\u00a7a(?<username>\\w{1,16}) left the game\\.");
    private static final int REQUEST_RATELIMIT = 250;
    private ListStatus friendMessageStatus = ListStatus.IDLE;
    private long lastFriendRequest = 0L;
    private ListStatus onlineMessageStatus = ListStatus.IDLE;
    private long lastOnlineRequest = 0L;
    private Set<String> friends;
    private Map<String, String> onlineFriends = new HashMap<String, String>();

    public FriendsModel() {
        super(List.of());
        this.resetData();
    }

    @SubscribeEvent
    public void onAuth(HadesEvent.Authenticated event) {
        if (!Models.WorldState.onWorld()) {
            return;
        }
        this.requestData();
    }

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent event) {
        if (event.getNewState() == WorldState.WORLD) {
            this.requestData();
        } else {
            this.resetData();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onChatReceived(ChatMessageEvent.Match event) {
        if (event.getMessageType() != MessageType.FOREGROUND) {
            return;
        }
        StyledText styledText = StyledTextUtils.unwrap(event.getMessage()).stripAlignment();
        String unformatted = styledText.getStringWithoutFormatting();
        Matcher joinMatcher = styledText.getMatcher(JOIN_PATTERN);
        if (joinMatcher.matches()) {
            String username = joinMatcher.group("username");
            String server = joinMatcher.group("server");
            this.onlineFriends.put(username, server);
            WynntilsMod.postEvent(new FriendsEvent.Joined(username, server));
            return;
        }
        Matcher leaveMatcher = styledText.getMatcher(LEAVE_PATTERN);
        if (leaveMatcher.matches()) {
            String username = leaveMatcher.group("username");
            this.onlineFriends.remove(username);
            WynntilsMod.postEvent(new FriendsEvent.Left(username));
            return;
        }
        if (this.tryParseFriendMessages(styledText)) {
            return;
        }
        if (this.friendMessageStatus == ListStatus.EXPECTING) {
            if (this.tryParseFriendList(unformatted) || this.tryParseNoFriendList(styledText)) {
                event.setCanceled(true);
                this.friendMessageStatus = ListStatus.IDLE;
                return;
            }
            if (styledText.getMatcher(FRIEND_LIST_FAIL_1).matches()) {
                event.setCanceled(true);
                return;
            }
        }
        if (this.onlineMessageStatus == ListStatus.EXPECTING && styledText.getMatcher(ONLINE_FRIENDS_HEADER).matches()) {
            this.onlineMessageStatus = ListStatus.PROCESSING;
            this.onlineFriends.clear();
            event.setCanceled(true);
            return;
        }
        if (this.onlineMessageStatus == ListStatus.PROCESSING) {
            Matcher onlineFriendMatcher = styledText.getMatcher(ONLINE_FRIEND);
            if (onlineFriendMatcher.matches()) {
                String username = onlineFriendMatcher.group(1);
                String server = onlineFriendMatcher.group(2);
                this.onlineFriends.put(username, server);
                WynntilsMod.info("Friend " + username + " is online on " + server);
                event.setCanceled(true);
                return;
            }
            this.onlineMessageStatus = ListStatus.IDLE;
            WynntilsMod.postEvent(new FriendsEvent.OnlineListed());
        }
    }

    private boolean tryParseNoFriendList(StyledText styledText) {
        if (styledText.getMatcher(FRIEND_LIST_FAIL_2).matches()) {
            WynntilsMod.info("Friend list is empty.");
            return true;
        }
        return false;
    }

    private boolean tryParseFriendMessages(StyledText styledText) {
        Matcher matcher = styledText.getMatcher(FRIEND_REMOVE_MESSAGE_PATTERN);
        if (matcher.matches()) {
            String player = matcher.group(1);
            WynntilsMod.info("Player has removed friend: " + player);
            this.friends.remove(player);
            WynntilsMod.postEvent(new HadesRelationsUpdateEvent.FriendList(Set.of(player), HadesRelationsUpdateEvent.ChangeType.REMOVE));
            WynntilsMod.postEvent(new FriendsEvent.Removed(player));
            return true;
        }
        matcher = styledText.getMatcher(FRIEND_ADD_MESSAGE_PATTERN);
        if (matcher.matches()) {
            String player = matcher.group(1);
            WynntilsMod.info("Player has added friend: " + player);
            this.friends.add(player);
            WynntilsMod.postEvent(new HadesRelationsUpdateEvent.FriendList(Set.of(player), HadesRelationsUpdateEvent.ChangeType.ADD));
            WynntilsMod.postEvent(new FriendsEvent.Added(player));
            return true;
        }
        return false;
    }

    private boolean tryParseFriendList(String unformatted) {
        Matcher matcher = FRIEND_LIST.matcher(unformatted);
        if (!matcher.matches()) {
            return false;
        }
        String[] friendList = matcher.group(1).replaceAll(FRIEND_PREFIX_REGEX, "").split(", ");
        this.friends = Arrays.stream(friendList).collect(Collectors.toSet());
        WynntilsMod.postEvent(new HadesRelationsUpdateEvent.FriendList(this.friends, HadesRelationsUpdateEvent.ChangeType.RELOAD));
        WynntilsMod.postEvent(new FriendsEvent.Listed());
        WynntilsMod.info("Successfully updated friend list, user has " + friendList.length + " friends.");
        return true;
    }

    private void resetData() {
        this.friends = new HashSet<String>();
        this.onlineFriends = new HashMap<String, String>();
        WynntilsMod.postEvent(new HadesRelationsUpdateEvent.FriendList(this.friends, HadesRelationsUpdateEvent.ChangeType.RELOAD));
    }

    public void requestData() {
        if (McUtils.player() == null) {
            return;
        }
        if (System.currentTimeMillis() - this.lastFriendRequest > 250L) {
            this.friendMessageStatus = ListStatus.EXPECTING;
            this.lastFriendRequest = System.currentTimeMillis();
            Handlers.Command.queueCommand("friend list");
        } else {
            WynntilsMod.info("Skipping friend list request because it was requested very recently.");
        }
        if (System.currentTimeMillis() - this.lastOnlineRequest > 250L) {
            this.onlineMessageStatus = ListStatus.EXPECTING;
            this.lastOnlineRequest = System.currentTimeMillis();
            Handlers.Command.queueCommand("friend online");
        } else {
            WynntilsMod.info("Skipping online friend list request because it was requested very recently.");
        }
    }

    public boolean isFriend(String playerName) {
        return this.friends.contains(playerName);
    }

    public Set<String> getFriends() {
        return Collections.unmodifiableSet(this.friends);
    }

    public Map<String, String> getOnlineFriends() {
        return Collections.unmodifiableMap(this.onlineFriends);
    }

    private static enum ListStatus {
        IDLE,
        EXPECTING,
        PROCESSING;

    }
}

