/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.players.type;

import net.minecraft.ChatFormatting;

public enum PlayerRank {
    NONE("", "", ChatFormatting.DARK_GRAY),
    VIP("VIP", "\ue023", ChatFormatting.DARK_GREEN),
    VIP_PLUS("VIP+", "\ue024", ChatFormatting.BLUE),
    HERO("HERO", "\ue01b", ChatFormatting.DARK_PURPLE),
    HERO_PLUS("HERO+", "\ue08a", ChatFormatting.LIGHT_PURPLE),
    CHAMPION("CHAMPION", "\ue017", ChatFormatting.YELLOW),
    MEDIA("Media", "\ue01e", ChatFormatting.LIGHT_PURPLE),
    ARTIST("Artist", "\ue015", ChatFormatting.AQUA),
    BUILDER("Builder", "\ue016", ChatFormatting.AQUA),
    CMD("CMD", "\ue018", ChatFormatting.AQUA),
    GM("GM", "\ue01a", ChatFormatting.AQUA),
    HYBRID("Hybrid", "\ue01c", ChatFormatting.AQUA),
    ITEM("Item", "\ue01d", ChatFormatting.AQUA),
    MUSIC("Music", "\ue020", ChatFormatting.AQUA),
    QA("QA", "\ue022", ChatFormatting.AQUA),
    DEV("Dev", "\ue019", ChatFormatting.RED),
    MOD("Mod", "\ue01f", ChatFormatting.GOLD),
    ADMIN("Admin", "\ue014", ChatFormatting.RED),
    OWNER("Owner", "\ue021", ChatFormatting.DARK_RED),
    WEB("Web", "\ue025", ChatFormatting.RED);

    private final String name;
    private final String tag;
    private final ChatFormatting textColor;

    private PlayerRank(String name, String tag, ChatFormatting textColor) {
        this.name = name;
        this.tag = tag;
        this.textColor = textColor;
    }

    public static PlayerRank fromString(String rankString) {
        for (PlayerRank rank : PlayerRank.values()) {
            if (!rank.name.equals(rankString) && !rank.tag.equals(rankString)) continue;
            return rank;
        }
        return NONE;
    }

    public String getName() {
        return this.name;
    }

    public String getTag() {
        return this.tag;
    }

    public ChatFormatting getTextColor() {
        return this.textColor;
    }
}

