/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.profession;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Model;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.storage.Storage;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.chat.event.ChatMessageEvent;
import com.wynntils.handlers.labels.event.LabelIdentifiedEvent;
import com.wynntils.handlers.labels.type.LabelInfo;
import com.wynntils.models.profession.event.ProfessionXpGainEvent;
import com.wynntils.models.profession.label.CraftingStationLabelParser;
import com.wynntils.models.profession.label.GatheringNodeHarvestLabelInfo;
import com.wynntils.models.profession.label.GatheringNodeHarvestLabelParser;
import com.wynntils.models.profession.label.GatheringNodeLabelParser;
import com.wynntils.models.profession.type.HarvestInfo;
import com.wynntils.models.profession.type.ProfessionProgress;
import com.wynntils.models.profession.type.ProfessionType;
import com.wynntils.utils.mc.LoreUtils;
import com.wynntils.utils.type.CappedValue;
import com.wynntils.utils.type.TimedSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

public final class ProfessionModel
extends Model {
    private static final Pattern PROFESSION_CRAFT_PATTERN = Pattern.compile("(\u00a7dx[\\d\\.]+ )?\u00a77\\[\\+(\u00a7d)?(?<gain>\\d+) \u00a7f[\u24c0\u24b8\u24b7\u24bf\u24ba\u24b9\u24c1\u24b6\u24bc\u24bb\u24be\u24bd] \u00a77(?<name>.+) XP\\] \u00a76\\[(?<current>[\\d.]+)%\\]");
    private static final Pattern PROFESSION_LEVELUP_PATTERN = Pattern.compile("\u00a7e\\s+You are now level (?<level>\\d+) in \u00a7f[\u24c0\u24b8\u24b7\u24bf\u24ba\u24b9\u24c1\u24b6\u24bc\u24bb\u24be\u24bd]\u00a7e (?<name>.+)");
    private static final Pattern INFO_MENU_PROFESSION_LORE_PATTERN = Pattern.compile("\u00a76- \u00a77[\u24c0\u24b8\u24b7\u24bf\u24ba\u24b9\u24c1\u24b6\u24bc\u24bb\u24be\u24bd] Lv. (\\d+) (.+)\u00a78 \\[([\\d.]+)%\\]");
    private static final int MAX_HARVEST_LABEL_AGE = 4000;
    private static final int[] LEVEL_UP_XP_REQUIREMENTS = new int[]{30, 35, 42, 48, 56, 64, 74, 84, 96, 109, 123, 140, 158, 178, 200, 225, 253, 284, 319, 358, 401, 449, 502, 562, 629, 703, 786, 878, 981, 1096, 1224, 1367, 1526, 1704, 1901, 2122, 2368, 2643, 2948, 3289, 3670, 4094, 4567, 5094, 5682, 6337, 7068, 7882, 8791, 9804, 10933, 12193, 13597, 15162, 16908, 18855, 21025, 23445, 26143, 29151, 32506, 36246, 40416, 45066, 50250, 56031, 62477, 69664, 77677, 86612, 96574, 107682, 120068, 133877, 149275, 166444, 185587, 206932, 230731, 257267, 286855, 319845, 356629, 397643, 443374, 494364, 551218, 614610, 685292, 764103, 851977, 949956, 1059203, 1181014, 1316832, 1468270, 1637123, 1825394, 2035317, 2269380, 2530361, 2821354, 3145812, 3507582, 3910956, 4360718, 4862203, 5421358, 6044816, 6739972, 7515071, 8379306, 9342928, 10417367, 11615366, 12951135, 14440517, 16101179, 17952817, 20017392, 22319395, 24886127, 27748034, 30939059, 34497053, 38464216, 42887603, 47819680, 53318945, 59450625, 66287449};
    @Persisted
    private final Storage<Integer> professionDryStreak = new Storage<Integer>(0);
    private long lastGatherTime = 0L;
    private HarvestInfo lastHarvest;
    private final TimedSet<Integer> harvestIds = new TimedSet(4000L, TimeUnit.MILLISECONDS, true);
    private Map<ProfessionType, ProfessionProgress> professionProgressMap = new ConcurrentHashMap<ProfessionType, ProfessionProgress>();
    private final Map<ProfessionType, TimedSet<Float>> rawXpGainInLastMinute = new HashMap<ProfessionType, TimedSet<Float>>();
    private ProfessionType lastProfessionXpGain;

    public ProfessionModel() {
        super(List.of());
        Handlers.Label.registerParser(new GatheringNodeLabelParser());
        Handlers.Label.registerParser(new CraftingStationLabelParser());
        Handlers.Label.registerParser(new GatheringNodeHarvestLabelParser());
        for (ProfessionType pt : ProfessionType.values()) {
            this.rawXpGainInLastMinute.put(pt, new TimedSet(1L, TimeUnit.MINUTES, true));
        }
    }

    @SubscribeEvent
    public void onLabelIdentified(LabelIdentifiedEvent event) {
        LabelInfo labelInfo = event.getLabelInfo();
        if (labelInfo instanceof GatheringNodeHarvestLabelInfo) {
            GatheringNodeHarvestLabelInfo gatheringInfo = (GatheringNodeHarvestLabelInfo)labelInfo;
            if (this.harvestIds.stream().anyMatch(id -> id.intValue() == event.getLabelInfo().getEntity().getId())) {
                if (gatheringInfo.getMaterialProfile().isEmpty()) {
                    return;
                }
                if (this.lastGatherTime + 4000L >= System.currentTimeMillis()) {
                    this.lastHarvest = new HarvestInfo(this.lastGatherTime, gatheringInfo.getMaterialProfile().get(), gatheringInfo.getXpGain());
                    this.lastGatherTime = 0L;
                    if (this.lastHarvest.materialProfile().getTier() == 3) {
                        this.professionDryStreak.store(0);
                    } else {
                        this.professionDryStreak.store((Integer)this.professionDryStreak.get() + 1);
                    }
                }
                return;
            }
            this.harvestIds.put(gatheringInfo.getEntity().getId());
            this.lastGatherTime = System.currentTimeMillis();
            this.lastProfessionXpGain = gatheringInfo.getProfessionType();
            WynntilsMod.postEvent(new ProfessionXpGainEvent(gatheringInfo.getProfessionType(), gatheringInfo.getXpGain(), gatheringInfo.getCurrentXp()));
        }
    }

    @SubscribeEvent
    public void onChatMessage(ChatMessageEvent.Match event) {
        StyledText message = event.getMessage();
        Matcher craftMatcher = message.getMatcher(PROFESSION_CRAFT_PATTERN);
        if (craftMatcher.matches()) {
            this.lastProfessionXpGain = ProfessionType.fromString(craftMatcher.group("name"));
            ProfessionXpGainEvent xpGainEvent = new ProfessionXpGainEvent(ProfessionType.fromString(craftMatcher.group("name")), Float.parseFloat(craftMatcher.group("gain")), Float.parseFloat(craftMatcher.group("current")));
            WynntilsMod.postEvent(xpGainEvent);
            if (xpGainEvent.isCanceled()) {
                event.setCanceled(true);
            }
            return;
        }
        Matcher levelUpMatcher = message.getMatcher(PROFESSION_LEVELUP_PATTERN);
        if (levelUpMatcher.matches()) {
            this.updateLevel(ProfessionType.fromString(levelUpMatcher.group("name")), Integer.parseInt(levelUpMatcher.group("level")));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onXpGain(ProfessionXpGainEvent event) {
        ProfessionType profession = event.getProfession();
        ProfessionProgress oldValue = this.professionProgressMap.getOrDefault(profession, ProfessionProgress.NO_PROGRESS);
        float newPercentage = event.getCurrentXpPercentage();
        if (newPercentage == 100.0f) {
            newPercentage = 0.0f;
        }
        this.professionProgressMap.put(profession, new ProfessionProgress(oldValue.level(), newPercentage));
        this.rawXpGainInLastMinute.get(profession).put(Float.valueOf(event.getGainedXpRaw()));
    }

    public void resetValueFromItem(ItemStack professionInfoItem) {
        ConcurrentHashMap<ProfessionType, ProfessionProgress> levels = new ConcurrentHashMap<ProfessionType, ProfessionProgress>();
        LinkedList<StyledText> professionLore = LoreUtils.getLore(professionInfoItem);
        for (StyledText line : professionLore) {
            Matcher matcher = line.getMatcher(INFO_MENU_PROFESSION_LORE_PATTERN);
            if (!matcher.matches()) continue;
            levels.put(ProfessionType.fromString(matcher.group(2)), new ProfessionProgress(Integer.parseInt(matcher.group(1)), Float.parseFloat(matcher.group(3))));
        }
        for (ProfessionType value : ProfessionType.values()) {
            levels.putIfAbsent(value, ProfessionProgress.NO_PROGRESS);
        }
        this.professionProgressMap = levels;
    }

    private void updateLevel(ProfessionType type, int newLevel) {
        ProfessionProgress oldValue = this.professionProgressMap.getOrDefault(type, ProfessionProgress.NO_PROGRESS);
        this.professionProgressMap.put(type, new ProfessionProgress(newLevel, oldValue.progress()));
    }

    public int getLevel(ProfessionType type) {
        return this.professionProgressMap.getOrDefault(type, ProfessionProgress.NO_PROGRESS).level();
    }

    public double getProgress(ProfessionType type) {
        return this.professionProgressMap.getOrDefault(type, ProfessionProgress.NO_PROGRESS).progress();
    }

    public Optional<HarvestInfo> getLastHarvest() {
        return Optional.ofNullable(this.lastHarvest);
    }

    public Map<ProfessionType, TimedSet<Float>> getRawXpGainInLastMinute() {
        return Collections.unmodifiableMap(this.rawXpGainInLastMinute);
    }

    public int getProfessionDryStreak() {
        return (Integer)this.professionDryStreak.get();
    }

    public int getXpPointsNeededToLevelUp(ProfessionType type) {
        int levelIndex = this.getLevel(type) - 1;
        if (levelIndex >= LEVEL_UP_XP_REQUIREMENTS.length) {
            return Integer.MAX_VALUE;
        }
        if (levelIndex < 0) {
            return 0;
        }
        return LEVEL_UP_XP_REQUIREMENTS[levelIndex];
    }

    public CappedValue getXP(ProfessionType type) {
        int maxXP = this.getXpPointsNeededToLevelUp(type);
        return CappedValue.fromProgress((float)(this.getProgress(type) / 100.0), maxXP);
    }

    public Optional<ProfessionType> getLastProfessionXpGain() {
        return Optional.ofNullable(this.lastProfessionXpGain);
    }
}

