/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.rewards.type;

import com.wynntils.models.rewards.type.CharmInfo;
import com.wynntils.models.stats.StatCalculator;
import com.wynntils.models.stats.type.StatActualValue;
import java.util.List;
import java.util.Optional;

public record CharmInstance(int rerolls, List<StatActualValue> identifications, Optional<Float> overallQuality) {
    public static CharmInstance create(int rerolls, CharmInfo charmInfo, List<StatActualValue> identifications) {
        return new CharmInstance(rerolls, identifications, StatCalculator.calculateOverallQuality(charmInfo.name(), charmInfo.getPossibleValueList(), identifications));
    }

    public boolean hasOverallValue() {
        return this.overallQuality.isPresent();
    }

    public float getOverallPercentage() {
        return this.overallQuality.orElse(Float.valueOf(0.0f)).floatValue();
    }

    public boolean isPerfect() {
        return this.overallQuality.orElse(Float.valueOf(0.0f)).floatValue() >= 100.0f;
    }

    public boolean isDefective() {
        return this.overallQuality.isPresent() && this.overallQuality.orElse(Float.valueOf(0.0f)).floatValue() <= 0.0f;
    }
}

