/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.stats.builders;

import com.wynntils.models.character.type.ClassType;
import com.wynntils.models.spells.type.SpellType;
import com.wynntils.models.stats.builders.StatBuilder;
import com.wynntils.models.stats.type.SpellStatType;
import com.wynntils.models.stats.type.StatUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public final class SpellStatBuilder
extends StatBuilder<SpellStatType> {
    @Override
    public void buildStats(Consumer<SpellStatType> callback) {
        for (int spellNumber = 1; spellNumber <= 4; ++spellNumber) {
            SpellType spellType = SpellType.forClass(ClassType.NONE, spellNumber);
            callback.accept(this.buildSpellStat(spellType, StatUnit.PERCENT));
            callback.accept(this.buildSpellStat(spellType, StatUnit.RAW));
        }
    }

    public static String getStatNameForSpell(String spellName) {
        return spellName + " Cost";
    }

    public static List<String> getAliases(SpellStatType statType) {
        ArrayList<String> aliases = new ArrayList<String>();
        SpellType genericSpell = statType.getSpellType();
        for (ClassType classType : ClassType.values()) {
            if (classType == ClassType.NONE) continue;
            SpellType classSpecificSpell = genericSpell.forOtherClass(classType);
            aliases.add(SpellStatBuilder.getStatNameForSpell(classSpecificSpell.getName()));
        }
        String unidentifiedAliasName = SpellStatBuilder.getStatNameForSpell("{sp" + genericSpell.getSpellNumber() + "}");
        aliases.add(unidentifiedAliasName);
        return Collections.unmodifiableList(aliases);
    }

    private SpellStatType buildSpellStat(SpellType spellType, StatUnit unit) {
        String apiUnit = unit == StatUnit.RAW ? "raw" : "";
        String loreUnit = unit == StatUnit.RAW ? "RAW" : "PCT";
        int spellNumber = spellType.getSpellNumber();
        String spellNumberString = switch (spellNumber) {
            case 1 -> "1st";
            case 2 -> "2nd";
            case 3 -> "3rd";
            case 4 -> "4th";
            default -> throw new IllegalArgumentException("Invalid spell number: " + spellNumber);
        };
        return new SpellStatType("SPELL_" + spellType.name() + "_COST_" + unit.name(), SpellStatBuilder.getStatNameForSpell(spellType.getName()), apiUnit + spellNumberString + "SpellCost", "SPELL_COST_" + loreUnit + "_" + spellNumber, unit, spellType);
    }
}

