/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.stats.type;

import com.wynntils.models.elements.type.Element;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;

public final class DamageType
extends Enum<DamageType> {
    public static final /* enum */ DamageType ALL = new DamageType("", "\u2764", ChatFormatting.DARK_RED);
    public static final /* enum */ DamageType NEUTRAL = new DamageType("Neutral", "\ue005", ChatFormatting.GOLD, 5);
    public static final /* enum */ DamageType FIRE = new DamageType(Element.FIRE);
    public static final /* enum */ DamageType WATER = new DamageType(Element.WATER);
    public static final /* enum */ DamageType AIR = new DamageType(Element.AIR);
    public static final /* enum */ DamageType THUNDER = new DamageType(Element.THUNDER);
    public static final /* enum */ DamageType EARTH = new DamageType(Element.EARTH);
    public static final /* enum */ DamageType RAINBOW = new DamageType("Elemental");
    public static final /* enum */ DamageType POISON = new DamageType("Poison", "\u2620", ChatFormatting.DARK_PURPLE);
    private final Element element;
    private final String displayName;
    private final String apiName;
    private final String symbol;
    private final ChatFormatting colorCode;
    private final int encodingId;
    private static final /* synthetic */ DamageType[] $VALUES;

    public static DamageType[] values() {
        return (DamageType[])$VALUES.clone();
    }

    public static DamageType valueOf(String name) {
        return Enum.valueOf(DamageType.class, name);
    }

    private DamageType(String name) {
        this.element = null;
        this.displayName = name.isEmpty() ? "" : name + " ";
        this.apiName = name;
        this.symbol = "";
        this.colorCode = null;
        this.encodingId = -1;
    }

    private DamageType(String name, String symbol, ChatFormatting colorCode) {
        this.element = null;
        this.displayName = name.isEmpty() ? "" : name + " ";
        this.apiName = name;
        this.symbol = symbol;
        this.colorCode = colorCode;
        this.encodingId = -1;
    }

    private DamageType(String name, String symbol, ChatFormatting colorCode, int encodingId) {
        this.element = null;
        this.displayName = name.isEmpty() ? "" : name + " ";
        this.apiName = name;
        this.symbol = symbol;
        this.colorCode = colorCode;
        this.encodingId = encodingId;
    }

    private DamageType(Element element) {
        this.element = element;
        this.displayName = element.getDisplayName() + " ";
        this.apiName = element.getDisplayName();
        this.symbol = element.getSymbol();
        this.colorCode = element.getColorCode();
        this.encodingId = element.getEncodingId();
    }

    public static List<DamageType> statValues() {
        return Arrays.stream(DamageType.values()).filter(type -> type != POISON).toList();
    }

    public static DamageType fromElement(Element element) {
        for (DamageType type : DamageType.values()) {
            if (type.element != element) continue;
            return type;
        }
        return null;
    }

    public static DamageType fromSymbol(String symbol) {
        for (DamageType type : DamageType.values()) {
            if (!type.symbol.equals(symbol)) continue;
            return type;
        }
        return null;
    }

    public static DamageType fromEncodingId(int id) {
        for (DamageType type : DamageType.values()) {
            if (type.encodingId != id) continue;
            return type;
        }
        return null;
    }

    public Optional<Element> getElement() {
        return Optional.ofNullable(this.element);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getApiName() {
        return this.apiName;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public ChatFormatting getColorCode() {
        return this.colorCode;
    }

    public int getEncodingId() {
        assert (this.encodingId != -1) : "Encoding id not set for " + String.valueOf((Object)this);
        return this.encodingId;
    }

    private static /* synthetic */ DamageType[] $values() {
        return new DamageType[]{ALL, NEUTRAL, FIRE, WATER, AIR, THUNDER, EARTH, RAINBOW, POISON};
    }

    static {
        $VALUES = DamageType.$values();
    }
}

