/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.territories;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.chat.event.ChatMessageEvent;
import com.wynntils.handlers.scoreboard.ScoreboardPart;
import com.wynntils.handlers.scoreboard.ScoreboardSegment;
import com.wynntils.mc.event.TickEvent;
import com.wynntils.models.marker.MarkerModel;
import com.wynntils.models.territories.GuildAttackScoreboardPart;
import com.wynntils.models.territories.TerritoryAttackTimer;
import com.wynntils.models.territories.event.GuildWarQueuedEvent;
import com.wynntils.models.territories.markers.GuildAttackMarkerProvider;
import com.wynntils.models.territories.profile.TerritoryProfile;
import com.wynntils.models.territories.type.GuildResourceValues;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.StyledTextUtils;
import com.wynntils.utils.type.TimedSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.neoforged.bus.api.SubscribeEvent;

public final class GuildAttackTimerModel
extends Model {
    private static final Pattern GUILD_ATTACK_PATTERN = Pattern.compile("\u00a7b- (.+):(.+) \u00a73(.+)");
    private static final Pattern GUILD_DEFENSE_CHAT_PATTERN = Pattern.compile("\u00a7b.+\u00a7b (.+) defense is (.+)");
    private static final Pattern WAR_MESSAGE_PATTERN = Pattern.compile("\u00a7c(?:\ue006\ue002|\ue001) The war for (?<territory>.+) will start in ((?<minutes>\\d+) minute(?:s)?)?(?: and )?((?<seconds>\\d+) second(?:s)?)?\\.");
    private static final Pattern CAPTURED_PATTERN = Pattern.compile("\u00a7c(?:\ue006\ue002|\ue001) \\[(?<guild>.+)\\] (?:has )?captured the territory (?<territory>.+)\\.");
    private static final ScoreboardPart GUILD_ATTACK_SCOREBOARD_PART = new GuildAttackScoreboardPart();
    private static final GuildAttackMarkerProvider GUILD_ATTACK_MARKER_PROVIDER = new GuildAttackMarkerProvider();
    private final Map<String, GuildResourceValues> territoryDefenses = new HashMap<String, GuildResourceValues>();
    private final Map<String, TerritoryAttackTimer> chatAttackTimers = new HashMap<String, TerritoryAttackTimer>();
    private final Map<String, TerritoryAttackTimer> scoreboardAttackTimers = new HashMap<String, TerritoryAttackTimer>();
    private final TimedSet<String> capturedTerritories = new TimedSet(10L, TimeUnit.SECONDS, true);

    public GuildAttackTimerModel(MarkerModel marker) {
        super(List.of(marker));
        Handlers.Scoreboard.addPart(GUILD_ATTACK_SCOREBOARD_PART);
        Models.Marker.registerMarkerProvider(GUILD_ATTACK_MARKER_PROVIDER);
    }

    @SubscribeEvent
    public void onMessage(ChatMessageEvent.Match event) {
        StyledText cleanMessaage = StyledTextUtils.unwrap(event.getMessage()).stripAlignment();
        Matcher matcher = cleanMessaage.getMatcher(WAR_MESSAGE_PATTERN);
        if (matcher.matches()) {
            long timerEnd = System.currentTimeMillis();
            if (matcher.group("minutes") != null) {
                timerEnd += Long.parseLong(matcher.group("minutes")) * 60L * 1000L;
            }
            if (matcher.group("seconds") != null) {
                timerEnd += Long.parseLong(matcher.group("seconds")) * 1000L;
            }
            String territory = matcher.group("territory");
            TerritoryAttackTimer scoreboardTimer = this.scoreboardAttackTimers.remove(territory);
            TerritoryAttackTimer attackTimer = new TerritoryAttackTimer(territory, timerEnd);
            TerritoryAttackTimer oldTimer = this.chatAttackTimers.put(territory, attackTimer);
            if (oldTimer == null && scoreboardTimer == null) {
                WynntilsMod.postEvent(new GuildWarQueuedEvent(attackTimer));
            }
            return;
        }
        matcher = cleanMessaage.getMatcher(CAPTURED_PATTERN);
        if (matcher.matches()) {
            String territory = matcher.group("territory");
            this.chatAttackTimers.remove(territory);
            this.scoreboardAttackTimers.remove(territory);
            this.capturedTerritories.put(territory);
            return;
        }
        matcher = cleanMessaage.getMatcher(GUILD_DEFENSE_CHAT_PATTERN);
        if (matcher.matches()) {
            String territory = matcher.group(1);
            this.territoryDefenses.put(territory, GuildResourceValues.fromString(matcher.group(2)));
            return;
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent event) {
        if (McUtils.player().tickCount % 20 != 0) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        ArrayList<String> removedTimers = new ArrayList<String>();
        for (Map.Entry<String, TerritoryAttackTimer> entry : this.chatAttackTimers.entrySet()) {
            if (entry.getValue().timerEnd() >= currentTime) continue;
            removedTimers.add(entry.getKey());
        }
        removedTimers.forEach(this.chatAttackTimers::remove);
        removedTimers.clear();
        for (Map.Entry<String, TerritoryAttackTimer> entry : this.scoreboardAttackTimers.entrySet()) {
            if (entry.getValue().timerEnd() >= currentTime) continue;
            removedTimers.add(entry.getKey());
        }
        removedTimers.forEach(this.scoreboardAttackTimers::remove);
    }

    public List<TerritoryAttackTimer> getAttackTimers() {
        return this.getUpcomingTimers().toList();
    }

    public Optional<TerritoryAttackTimer> getAttackTimerForTerritory(String territory) {
        return this.getUpcomingTimers().filter(t -> t.territoryName().equals(territory)).findFirst();
    }

    public Stream<TerritoryAttackTimer> getUpcomingTimers() {
        return Stream.concat(this.chatAttackTimers.values().stream(), this.scoreboardAttackTimers.values().stream()).filter(t -> t.timerEnd() > System.currentTimeMillis());
    }

    public Optional<GuildResourceValues> getDefenseForTerritory(String territory) {
        return Optional.ofNullable(this.territoryDefenses.get(territory));
    }

    void processScoreboardChanges(ScoreboardSegment segment) {
        HashSet<String> usedTerritories = new HashSet<String>();
        for (StyledText line : segment.getContent()) {
            int seconds;
            Matcher matcher = line.getMatcher(GUILD_ATTACK_PATTERN);
            if (!matcher.matches()) continue;
            String shortTerritoryName = matcher.group(3);
            Optional<TerritoryAttackTimer> chatTimerOpt = this.chatAttackTimers.values().stream().filter(timer -> timer.territoryName().startsWith(shortTerritoryName)).min((a, b) -> (int)(a.timerEnd() - b.timerEnd()));
            if (chatTimerOpt.isPresent()) {
                usedTerritories.add(chatTimerOpt.get().territoryName());
                continue;
            }
            TerritoryProfile territoryProfile = Models.Territory.getTerritoryProfileFromShortName(shortTerritoryName, usedTerritories);
            if (territoryProfile == null) {
                if (!usedTerritories.stream().noneMatch(ex -> ex.equals(shortTerritoryName))) continue;
                WynntilsMod.warn("Received scoreboard attack timer for unknown territory: " + shortTerritoryName);
                continue;
            }
            String fullTerritoryName = territoryProfile.getFriendlyName();
            if (this.capturedTerritories.stream().anyMatch(t -> Objects.equals(t, fullTerritoryName))) continue;
            usedTerritories.add(fullTerritoryName);
            int minutes = Integer.parseInt(matcher.group(1));
            long timerEnd = ((long)minutes * 60L + (long)(seconds = Integer.parseInt(matcher.group(2)))) * 1000L + System.currentTimeMillis();
            TerritoryAttackTimer timer2 = new TerritoryAttackTimer(fullTerritoryName, timerEnd);
            TerritoryAttackTimer oldTimer = this.scoreboardAttackTimers.put(fullTerritoryName, timer2);
            if (oldTimer != null) continue;
            WynntilsMod.postEvent(new GuildWarQueuedEvent(timer2));
        }
    }
}

