/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.territories.profile;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.wynntils.utils.DateFormatter;
import com.wynntils.utils.mc.type.PoiLocation;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Position;

public class TerritoryProfile {
    private static final DateFormatter DATE_FORMATTER = new DateFormatter(false);
    private final String name;
    private final String friendlyName;
    private final TerritoryLocation territoryLocation;
    private final GuildInfo guildInfo;
    private final Instant acquired;

    public TerritoryProfile(String name, String friendlyName, TerritoryLocation territoryLocation, GuildInfo guildInfo, Instant acquired) {
        this.name = name;
        this.friendlyName = friendlyName;
        this.territoryLocation = territoryLocation;
        this.guildInfo = guildInfo;
        this.acquired = acquired;
    }

    public GuildInfo getGuildInfo() {
        return this.guildInfo;
    }

    public String getName() {
        return this.name;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public int getStartX() {
        return this.territoryLocation.startX();
    }

    public int getStartZ() {
        return this.territoryLocation.startZ();
    }

    public int getEndX() {
        return this.territoryLocation.endX();
    }

    public int getEndZ() {
        return this.territoryLocation.endZ();
    }

    public String getGuild() {
        return this.guildInfo.name();
    }

    public String getGuildPrefix() {
        return this.guildInfo.prefix();
    }

    public Instant getAcquired() {
        return this.acquired;
    }

    public PoiLocation getCenterLocation() {
        int xMiddle = (this.getStartX() + this.getEndX()) / 2;
        int zMiddle = (this.getStartZ() + this.getEndZ()) / 2;
        return new PoiLocation(xMiddle, 0, zMiddle);
    }

    public boolean insideArea(Position position) {
        return position.x() >= (double)this.getStartX() && position.x() <= (double)this.getEndX() && position.z() >= (double)this.getStartZ() && position.z() <= (double)this.getEndZ();
    }

    private long getTimeHeldInMillis() {
        if (this.acquired != null) {
            return System.currentTimeMillis() - this.acquired.toEpochMilli();
        }
        return 0L;
    }

    public boolean isOnCooldown() {
        return this.getTimeHeldInMillis() < 600000L;
    }

    public String getReadableRelativeTimeAcquired() {
        long difference = this.getTimeHeldInMillis();
        return DATE_FORMATTER.format(difference);
    }

    public ChatFormatting getTimeAcquiredColor() {
        long difference = this.getTimeHeldInMillis();
        if (difference < 3600000L) {
            return ChatFormatting.GREEN;
        }
        if (difference < 86400000L) {
            return ChatFormatting.YELLOW;
        }
        return ChatFormatting.RED;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TerritoryProfile that = (TerritoryProfile)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.friendlyName, that.friendlyName) && Objects.equals(this.territoryLocation, that.territoryLocation) && Objects.equals(this.guildInfo, that.guildInfo) && Objects.equals(this.acquired, that.acquired);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.friendlyName, this.territoryLocation, this.guildInfo, this.acquired);
    }

    public record TerritoryLocation(int startX, int startZ, int endX, int endZ) {
    }

    public record GuildInfo(String name, String prefix) {
        public static final GuildInfo NONE = new GuildInfo("No owner", "None");
    }

    public static class TerritoryDeserializer
    implements JsonDeserializer<TerritoryProfile> {
        public TerritoryProfile deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject territory = json.getAsJsonObject();
            int startX = 0x7FFFFFFE;
            int startZ = 0x7FFFFFFE;
            int endX = Integer.MAX_VALUE;
            int endZ = Integer.MAX_VALUE;
            if (territory.has("location")) {
                int temp;
                JsonObject location = territory.getAsJsonObject("location");
                JsonArray start = location.getAsJsonArray("start");
                startX = start.get(0).getAsInt();
                startZ = start.get(1).getAsInt();
                JsonArray end = location.getAsJsonArray("end");
                endX = end.get(0).getAsInt();
                endZ = end.get(1).getAsInt();
                if (startX > endX) {
                    temp = startX;
                    startX = endX;
                    endX = temp;
                }
                if (startZ > endZ) {
                    temp = startZ;
                    startZ = endZ;
                    endZ = temp;
                }
            }
            TerritoryLocation territoryLocation = new TerritoryLocation(startX, startZ, endX, endZ);
            String territoryName = territory.get("name").getAsString();
            String friendlyName = territoryName.replace('\u2019', '\'');
            JsonElement guildJson = territory.get("guild");
            GuildInfo guild = guildJson.isJsonNull() || !guildJson.isJsonObject() || guildJson.getAsJsonObject().get("name").isJsonNull() || guildJson.getAsJsonObject().get("prefix").isJsonNull() ? GuildInfo.NONE : (GuildInfo)context.deserialize(guildJson, GuildInfo.class);
            JsonElement acquiredJson = territory.get("acquired");
            Instant acquired = acquiredJson.isJsonNull() ? null : Instant.parse(acquiredJson.getAsString());
            return new TerritoryProfile(territoryName, friendlyName, territoryLocation, guild, acquired);
        }
    }
}

