/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.war;

import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Model;
import com.wynntils.core.components.Services;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.storage.Storage;
import com.wynntils.handlers.scoreboard.ScoreboardPart;
import com.wynntils.models.war.event.GuildWarEvent;
import com.wynntils.models.war.scoreboard.WarScoreboardPart;
import com.wynntils.models.war.type.HistoricWarInfo;
import com.wynntils.models.war.type.WarBattleInfo;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.models.worlds.type.WorldState;
import com.wynntils.services.hades.HadesUser;
import com.wynntils.utils.mc.McUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Position;
import net.neoforged.bus.api.SubscribeEvent;

public final class WarModel
extends Model {
    private static final int WAR_RADIUS = 100;
    private static final ScoreboardPart WAR_SCOREBOARD_PART = new WarScoreboardPart();
    @Persisted
    public final Storage<List<HistoricWarInfo>> historicWars = new Storage(new ArrayList());
    private List<HadesUser> hadesUsers = new ArrayList<HadesUser>();
    private boolean warActive = false;

    public WarModel() {
        super(List.of());
        Handlers.Scoreboard.addPart(WAR_SCOREBOARD_PART);
    }

    @SubscribeEvent
    public void onWarEnd(GuildWarEvent.Ended event) {
        WarBattleInfo warBattleInfo = event.getWarBattleInfo();
        ((List)this.historicWars.get()).add(new HistoricWarInfo(warBattleInfo.getTerritory(), warBattleInfo.getOwnerGuild(), warBattleInfo.getInitialState(), warBattleInfo.getCurrentState(), System.currentTimeMillis()));
        this.historicWars.touched();
    }

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent event) {
        if (event.getNewState() != WorldState.WORLD) {
            this.onWarEnd();
        }
    }

    public void onWarStart() {
        this.hadesUsers = Services.Hades.getHadesUsers().filter(hadesUser -> hadesUser.getMapLocation().asLocation().toVec3().closerThan((Position)McUtils.player().position(), 100.0)).toList();
        this.warActive = true;
    }

    public void onWarEnd() {
        this.hadesUsers = new ArrayList<HadesUser>();
        this.warActive = false;
    }

    public List<HadesUser> getHadesUsers() {
        return this.hadesUsers;
    }

    public boolean isWarActive() {
        return this.warActive;
    }
}

