/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.worlds.bossbars;

import com.wynntils.core.components.Models;
import com.wynntils.handlers.bossbar.TrackedBar;
import com.wynntils.models.worlds.type.BombInfo;
import com.wynntils.models.worlds.type.BombType;
import com.wynntils.utils.type.CappedValue;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InfoBar
extends TrackedBar {
    private static final Pattern TERRITORY_INFO_PATTERN = Pattern.compile("\u00a7[abc](?<territory>[a-zA-Z\\s]+)\u00a7[234] (?<tag>\ue060\udaff\udfff.*\udb00\udc02)");
    private static final Pattern GUILD_INFO_PATTERN = Pattern.compile("\u00a77Lv\\. (?<level>\\d+)\u00a7f - \u00a7b(?<guild>[a-zA-Z\\s]+)\u00a7f - \u00a77(?<xp>\\d+)% XP");
    private static final Pattern BOMB_INFO_PATTERN = Pattern.compile("\u00a7#a0c84bff(?:Double )?(?<bomb>.+) from \u00a7#ffd750ff(?<user>.+)\u00a7#a0c84bff \u00a77\\[\u00a7f(?<length>\\d+)(?<unit>m|s)\u00a77\\]");
    private static final float BOMB_TIMER_OFFSET = 0.5f;

    public InfoBar() {
        super(List.of(TERRITORY_INFO_PATTERN, GUILD_INFO_PATTERN, BOMB_INFO_PATTERN));
    }

    @Override
    public void onUpdateName(Matcher matcher) {
        if (matcher.pattern().equals(BOMB_INFO_PATTERN)) {
            BombType bombType = BombType.fromString(matcher.group("bomb"));
            if (bombType == null) {
                return;
            }
            float length = Integer.parseInt(matcher.group("length"));
            length = matcher.group("unit").equals("m") ? (length += 0.5f) : (length /= 60.0f);
            Models.Bomb.addBombInfoFromInfoBar(new BombInfo(matcher.group("user"), bombType, Models.WorldState.getCurrentWorldName(), System.currentTimeMillis(), length));
        } else if (matcher.pattern().equals(GUILD_INFO_PATTERN)) {
            Models.Guild.setGuildLevel(Integer.parseInt(matcher.group("level")));
            Models.Guild.setGuildLevelProgress(new CappedValue(Integer.parseInt(matcher.group("xp")), 100));
        }
    }
}

