/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.wynnitem.type;

import com.wynntils.core.components.Models;
import com.wynntils.models.gear.type.GearType;
import com.wynntils.utils.mc.SkinUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.datafix.fixes.ItemIdFix;
import net.minecraft.util.datafix.fixes.ItemStackTheFlatteningFix;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.level.ItemLike;

public record ItemMaterial(ItemStack itemStack) {
    public static ItemMaterial getDefaultTomeItemMaterial() {
        ItemStack itemStack = ItemMaterial.createItemStack(Items.ENCHANTED_BOOK, 0.0f);
        return new ItemMaterial(itemStack);
    }

    public static ItemMaterial getDefaultCharmItemMaterial() {
        ItemStack itemStack = ItemMaterial.createItemStack(Items.CLAY, 0.0f);
        return new ItemMaterial(itemStack);
    }

    public static ItemMaterial fromPlayerHeadUUID(String uuid) {
        ItemStack itemStack = ItemMaterial.createItemStack(Items.PLAYER_HEAD, 0.0f);
        SkinUtils.setPlayerHeadFromUUID(itemStack, uuid);
        return new ItemMaterial(itemStack);
    }

    public static ItemMaterial fromGearType(GearType gearType) {
        ItemStack itemStack = ItemMaterial.createItemStack(gearType.getDefaultItem(), gearType.getDefaultModel());
        return new ItemMaterial(itemStack);
    }

    public static ItemMaterial fromItemId(String itemId, int customModelData) {
        ItemStack itemStack = ItemMaterial.createItemStack(ItemMaterial.getItem(itemId), customModelData);
        return new ItemMaterial(itemStack);
    }

    public static ItemMaterial fromItemTypeCode(int itemTypeCode, int damageCode) {
        String toIdString;
        String alternativeName;
        Optional<String> materialNameOverrideOpt = Models.WynnItem.getMaterialName(itemTypeCode, damageCode);
        Object itemId = materialNameOverrideOpt.isPresent() ? "minecraft:" + materialNameOverrideOpt.get() : ((alternativeName = ItemStackTheFlatteningFix.updateItem((String)(toIdString = ItemIdFix.getItem((int)itemTypeCode)), (int)damageCode)) != null ? alternativeName : toIdString);
        return ItemMaterial.fromItemId((String)itemId, damageCode);
    }

    private static ItemStack createItemStack(Item item, float modelValue) {
        ItemStack itemStack = new ItemStack((ItemLike)item);
        CustomModelData customModelData = new CustomModelData(List.of(Float.valueOf(modelValue)), List.of(), List.of(), List.of());
        itemStack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)customModelData);
        itemStack.set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(false));
        return itemStack;
    }

    private static Item getItem(String itemId) {
        return (Item)BuiltInRegistries.ITEM.getValue(ResourceLocation.parse((String)itemId));
    }
}

