/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.overlays;

import com.mojang.blaze3d.platform.Window;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.overlays.Overlay;
import com.wynntils.core.consumers.overlays.OverlayPosition;
import com.wynntils.core.consumers.overlays.OverlaySize;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.scoreboard.event.ScoreboardSegmentAdditionEvent;
import com.wynntils.models.activities.ActivityTrackerScoreboardPart;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.TextRenderSetting;
import com.wynntils.utils.render.TextRenderTask;
import com.wynntils.utils.render.buffered.BufferedFontRenderer;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

public class ContentTrackerOverlay
extends Overlay {
    private static final String PREVIEW_TASK = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer tempus purus in lacus pulvinar dictum. Quisque suscipit erat pellentesque egestas volutpat. ";
    @Persisted
    private final Config<Boolean> disableTrackerOnScoreboard = new Config<Boolean>(true);
    @Persisted
    private final Config<TextShadow> textShadow = new Config<TextShadow>(TextShadow.OUTLINE);
    private static final List<CustomColor> TEXT_COLORS = List.of(CommonColors.GREEN, CommonColors.ORANGE, CommonColors.WHITE);
    private final List<TextRenderTask> toRender = this.createRenderTaskList();
    private final List<TextRenderTask> toRenderPreview = this.createRenderTaskList();

    public ContentTrackerOverlay() {
        super(new OverlayPosition(5.0f, -5.0f, VerticalAlignment.TOP, HorizontalAlignment.RIGHT, OverlayPosition.AnchorSection.TOP_RIGHT), new OverlaySize(300.0f, 50.0f), HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE);
        this.toRenderPreview.get(0).setText(I18n.get((String)"feature.wynntils.contentTrackerOverlay.overlay.contentTracker.title", (Object[])new Object[0]) + " Quest:");
        this.toRenderPreview.get(1).setText(I18n.get((String)"feature.wynntils.contentTrackerOverlay.overlay.contentTracker.testQuestName", (Object[])new Object[0]) + ":");
        this.toRenderPreview.get(2).setText(PREVIEW_TASK);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onScoreboardSegmentChange(ScoreboardSegmentAdditionEvent event) {
        if (((Boolean)this.disableTrackerOnScoreboard.get()).booleanValue() && event.getSegment().getScoreboardPart() instanceof ActivityTrackerScoreboardPart) {
            event.setCanceled(true);
        }
    }

    @Override
    protected void onConfigUpdate(Config<?> config) {
        this.updateTextRenderSettings(this.toRender);
    }

    @Override
    public void render(GuiGraphics guiGraphics, MultiBufferSource bufferSource, DeltaTracker deltaTracker, Window window) {
        if (!Models.Activity.isTracking()) {
            return;
        }
        this.toRender.get(0).setText(I18n.get((String)"feature.wynntils.contentTrackerOverlay.overlay.contentTracker.title", (Object[])new Object[0]) + " " + Models.Activity.getTrackedType().getDisplayName() + ":");
        this.toRender.get(1).setText(Models.Activity.getTrackedName());
        this.toRender.get(2).setText(Models.Activity.getTrackedTask());
        BufferedFontRenderer.getInstance().renderTextsWithAlignment(guiGraphics.pose(), bufferSource, this.getRenderX(), this.getRenderY(), this.toRender, this.getWidth(), this.getHeight(), this.getRenderHorizontalAlignment(), this.getRenderVerticalAlignment());
    }

    @Override
    public void renderPreview(GuiGraphics guiGraphics, MultiBufferSource bufferSource, DeltaTracker deltaTracker, Window window) {
        this.updateTextRenderSettings(this.toRenderPreview);
        BufferedFontRenderer.getInstance().renderTextsWithAlignment(guiGraphics.pose(), bufferSource, this.getRenderX(), this.getRenderY(), this.toRenderPreview, this.getWidth(), this.getHeight(), this.getRenderHorizontalAlignment(), this.getRenderVerticalAlignment());
    }

    private List<TextRenderTask> createRenderTaskList() {
        ArrayList<TextRenderTask> renderTaskList = new ArrayList<TextRenderTask>(3);
        for (int i = 0; i < 3; ++i) {
            renderTaskList.add(new TextRenderTask(StyledText.EMPTY, TextRenderSetting.DEFAULT.withMaxWidth(this.getWidth()).withCustomColor(TEXT_COLORS.get(i)).withHorizontalAlignment(this.getRenderHorizontalAlignment()).withTextShadow((TextShadow)this.textShadow.get())));
        }
        return renderTaskList;
    }

    private void updateTextRenderSettings(List<TextRenderTask> renderTasks) {
        for (int i = 0; i < 3; ++i) {
            renderTasks.get(i).setSetting(TextRenderSetting.DEFAULT.withMaxWidth(this.getWidth()).withCustomColor(TEXT_COLORS.get(i)).withHorizontalAlignment(this.getRenderHorizontalAlignment()).withTextShadow((TextShadow)this.textShadow.get()));
        }
    }
}

