/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.overlays;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.overlays.Overlay;
import com.wynntils.core.consumers.overlays.OverlayPosition;
import com.wynntils.core.consumers.overlays.OverlaySize;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.characterstats.type.PowderSpecialInfo;
import com.wynntils.models.elements.type.Powder;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.buffered.BufferedFontRenderer;
import com.wynntils.utils.render.buffered.BufferedRenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.UniversalTexture;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.wynn.ItemUtils;
import java.util.Optional;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public class PowderSpecialBarOverlay
extends Overlay {
    @Persisted
    private final Config<TextShadow> textShadow = new Config<TextShadow>(TextShadow.OUTLINE);
    @Persisted
    private final Config<Boolean> flip = new Config<Boolean>(false);
    @Persisted
    private final Config<UniversalTexture> barTexture = new Config<UniversalTexture>(UniversalTexture.A);
    @Persisted
    private final Config<Boolean> onlyIfWeaponHeld = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> hideIfNoCharge = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> shouldDisplayOriginal = new Config<Boolean>(true);

    public PowderSpecialBarOverlay() {
        super(new OverlayPosition(-30.0f, 150.0f, VerticalAlignment.BOTTOM, HorizontalAlignment.CENTER, OverlayPosition.AnchorSection.BOTTOM_MIDDLE), new OverlaySize(81.0f, 21.0f));
    }

    @Override
    public void render(GuiGraphics guiGraphics, MultiBufferSource bufferSource, DeltaTracker deltaTracker, Window window) {
        Optional<PowderSpecialInfo> powderSpecialInfoOpt = Models.CharacterStats.getPowderSpecialInfo();
        if (((Boolean)this.hideIfNoCharge.get()).booleanValue() && powderSpecialInfoOpt.isEmpty()) {
            return;
        }
        if (((Boolean)this.onlyIfWeaponHeld.get()).booleanValue() && !ItemUtils.isWeapon(McUtils.inventory().getSelected())) {
            return;
        }
        PowderSpecialInfo powderSpecialInfo = powderSpecialInfoOpt.orElse(PowderSpecialInfo.EMPTY);
        this.renderWithSpecificSpecial(guiGraphics.pose(), bufferSource, powderSpecialInfo.charge() * 100.0f, powderSpecialInfo.powder());
    }

    @Override
    public void renderPreview(GuiGraphics guiGraphics, MultiBufferSource bufferSource, DeltaTracker deltaTracker, Window window) {
        this.renderWithSpecificSpecial(guiGraphics.pose(), bufferSource, 40.0f, Powder.THUNDER);
    }

    @Override
    protected void onConfigUpdate(Config<?> config) {
        Models.CharacterStats.setHidePowder(Managers.Overlay.isEnabled(this) && (Boolean)this.shouldDisplayOriginal.get() == false);
    }

    private void renderWithSpecificSpecial(PoseStack poseStack, MultiBufferSource bufferSource, float powderSpecialCharge, Powder powderSpecialType) {
        StyledText text;
        CustomColor color;
        float renderY;
        Texture universalBarTexture = Texture.UNIVERSAL_BAR;
        float renderedHeight = (float)((UniversalTexture)this.barTexture.get()).getHeight() * (this.getWidth() / 81.0f);
        switch (this.getRenderVerticalAlignment()) {
            default: {
                throw new MatchException(null, null);
            }
            case TOP: {
                float f = this.getRenderY();
                break;
            }
            case MIDDLE: {
                float f = this.getRenderY() + (this.getHeight() - renderedHeight) / 2.0f;
                break;
            }
            case BOTTOM: {
                float f = renderY = this.getRenderY() + this.getHeight() - renderedHeight;
            }
        }
        if (powderSpecialType == null) {
            color = CommonColors.GRAY;
            text = StyledText.fromString("Unknown");
        } else {
            color = powderSpecialType.getColor();
            text = StyledText.fromComponent((Component)Component.empty().withStyle(powderSpecialType.getLightColor()).append((Component)Component.literal((String)String.valueOf(powderSpecialType.getSymbol())).withStyle(Style.EMPTY.withFont(ResourceLocation.withDefaultNamespace((String)"common")))).append((Component)Component.literal((String)(" " + (int)powderSpecialCharge + "%"))));
        }
        BufferedFontRenderer.getInstance().renderAlignedTextInBox(poseStack, bufferSource, text, this.getRenderX(), this.getRenderX() + this.getWidth(), renderY, 0.0f, color, this.getRenderHorizontalAlignment(), (TextShadow)this.textShadow.get());
        BufferedRenderUtils.drawColoredProgressBar(poseStack, bufferSource, universalBarTexture, color, this.getRenderX(), renderY + 10.0f, this.getRenderX() + this.getWidth(), renderY + 10.0f + renderedHeight, 0, ((UniversalTexture)this.barTexture.get()).getTextureY1(), Texture.UNIVERSAL_BAR.width(), ((UniversalTexture)this.barTexture.get()).getTextureY2(), ((Boolean)this.flip.get() != false ? -1.0f : 1.0f) * powderSpecialCharge / 100.0f);
    }
}

