/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.overlays.minimap;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.overlays.Overlay;
import com.wynntils.core.consumers.overlays.OverlayPosition;
import com.wynntils.core.consumers.overlays.OverlaySize;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.text.StyledText;
import com.wynntils.features.map.MainMapFeature;
import com.wynntils.models.marker.MarkerModel;
import com.wynntils.services.hades.type.PlayerRelation;
import com.wynntils.services.map.MapTexture;
import com.wynntils.services.map.pois.PlayerMiniMapPoi;
import com.wynntils.services.map.pois.Poi;
import com.wynntils.services.map.pois.WaypointPoi;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.type.PoiLocation;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.MapRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.TextRenderSetting;
import com.wynntils.utils.render.TextRenderTask;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.PointerType;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.BoundingBox;
import com.wynntils.utils.type.BoundingCircle;
import com.wynntils.utils.type.BoundingShape;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;

public class MinimapOverlay
extends Overlay {
    private static final int DEFAULT_SIZE = 130;
    @Persisted
    private final Config<Float> zoomLevel = new Config<Float>(Float.valueOf(60.0f));
    @Persisted
    private final Config<Float> poiScale = new Config<Float>(Float.valueOf(0.6f));
    @Persisted
    private final Config<Float> pointerScale = new Config<Float>(Float.valueOf(0.8f));
    @Persisted
    private final Config<Boolean> followPlayerRotation = new Config<Boolean>(true);
    @Persisted
    public final Config<UnmappedOption> hideWhenUnmapped = new Config<UnmappedOption>(UnmappedOption.MINIMAP_AND_COORDS);
    @Persisted
    private final Config<CustomColor> pointerColor = new Config<CustomColor>(new CustomColor(1.0f, 1.0f, 1.0f, 1.0f));
    @Persisted
    private final Config<MapMaskType> maskType = new Config<MapMaskType>(MapMaskType.RECTANGULAR);
    @Persisted
    private final Config<MapBorderType> borderType = new Config<MapBorderType>(MapBorderType.WYNN);
    @Persisted
    private final Config<PointerType> pointerType = new Config<PointerType>(PointerType.ARROW);
    @Persisted
    private final Config<CompassRenderType> showCompass = new Config<CompassRenderType>(CompassRenderType.ALL);
    @Persisted
    private final Config<Boolean> renderRemoteFriendPlayers = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> renderRemotePartyPlayers = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> renderRemoteGuildPlayers = new Config<Boolean>(true);
    @Persisted
    public final Config<Float> remotePlayersHeadScale = new Config<Float>(Float.valueOf(0.4f));

    public MinimapOverlay() {
        super(new OverlayPosition(20.25f, 5.0f, VerticalAlignment.TOP, HorizontalAlignment.LEFT, OverlayPosition.AnchorSection.TOP_LEFT), new OverlaySize(130.0f, 130.0f));
    }

    private void setZoomLevel(float level) {
        float clampedLevel = MathUtils.clamp(level, 1.0f, 100.0f);
        if (clampedLevel == ((Float)this.zoomLevel.get()).floatValue()) {
            return;
        }
        this.zoomLevel.setValue(Float.valueOf(clampedLevel));
    }

    public void adjustZoomLevel(int delta) {
        this.setZoomLevel(((Float)this.zoomLevel.get()).floatValue() + (float)delta);
    }

    @Override
    public void render(GuiGraphics guiGraphics, MultiBufferSource bufferSource, DeltaTracker deltaTracker, Window window) {
        PoseStack poseStack = guiGraphics.pose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float width = this.getWidth();
        float height = this.getHeight();
        float renderX = this.getRenderX();
        float renderY = this.getRenderY();
        float centerX = renderX + width / 2.0f;
        float centerZ = renderY + height / 2.0f;
        double playerX = McUtils.player().getX();
        double playerZ = McUtils.player().getZ();
        float zoomRenderScale = MapRenderer.getZoomRenderScaleFromLevel(((Float)this.zoomLevel.get()).floatValue());
        BoundingCircle textureBoundingCircle = BoundingCircle.enclosingCircle(BoundingBox.centered((float)playerX, (float)playerZ, width * zoomRenderScale, height * zoomRenderScale));
        List<MapTexture> maps = Services.Map.getMapsForBoundingCircle(textureBoundingCircle);
        if (this.hideWhenUnmapped.get() != UnmappedOption.NEITHER && maps.isEmpty()) {
            return;
        }
        switch (((MapMaskType)((Object)this.maskType.get())).ordinal()) {
            case 0: {
                RenderUtils.enableScissor(guiGraphics, (int)renderX, (int)renderY, (int)width, (int)height);
                break;
            }
            case 1: {
                RenderUtils.createMask(poseStack, Texture.CIRCLE_MASK, (int)renderX, (int)renderY, (int)(renderX + width), (int)(renderY + height));
            }
        }
        RenderUtils.drawRect(poseStack, CommonColors.BLACK, renderX, renderY, 0.0f, width, height);
        if (((Boolean)this.followPlayerRotation.get()).booleanValue()) {
            poseStack.pushPose();
            RenderUtils.rotatePose(poseStack, centerX, centerZ, 180.0f - McUtils.mc().gameRenderer.getMainCamera().getYRot());
        }
        float extraFactor = 1.0f;
        if (((Boolean)this.followPlayerRotation.get()).booleanValue()) {
            extraFactor = 1.5f;
            extraFactor = width > height ? (extraFactor *= width / height) : (extraFactor *= height / width);
        }
        for (MapTexture map : maps) {
            float textureX = map.getTextureXPosition(playerX);
            float textureZ = map.getTextureZPosition(playerZ);
            MapRenderer.renderMapQuad(map, poseStack, centerX, centerZ, textureX, textureZ, width * extraFactor, height * extraFactor, zoomRenderScale);
        }
        if (((Boolean)this.followPlayerRotation.get()).booleanValue()) {
            poseStack.popPose();
        }
        this.renderPois(poseStack, centerX, centerZ, width, height, playerX, playerZ, zoomRenderScale, ((Float)this.zoomLevel.get()).floatValue(), textureBoundingCircle);
        MapRenderer.renderCursor(poseStack, centerX, centerZ, ((Float)this.pointerScale.get()).floatValue(), (CustomColor)this.pointerColor.get(), (PointerType)((Object)this.pointerType.get()), (Boolean)this.followPlayerRotation.get());
        switch (((MapMaskType)((Object)this.maskType.get())).ordinal()) {
            case 0: {
                RenderUtils.disableScissor(guiGraphics);
                break;
            }
            case 1: {
                RenderUtils.clearMask();
            }
        }
        this.renderMapBorder(poseStack, renderX, renderY, width, height);
        this.renderCardinalDirections(poseStack, width, height, centerX, centerZ);
    }

    private void renderPois(PoseStack poseStack, float centerX, float centerZ, float width, float height, double playerX, double playerZ, float zoomRenderScale, float zoomLevel, BoundingCircle textureBoundingCircle) {
        Poi[] pois;
        float cosRotationRadians;
        float sinRotationRadians;
        if (((Boolean)this.followPlayerRotation.get()).booleanValue()) {
            double rotationRadians = Math.toRadians(McUtils.mc().gameRenderer.getMainCamera().getYRot());
            sinRotationRadians = (float)StrictMath.sin(rotationRadians);
            cosRotationRadians = (float)(-StrictMath.cos(rotationRadians));
        } else {
            sinRotationRadians = 0.0f;
            cosRotationRadians = 0.0f;
        }
        float currentZoom = 1.0f / zoomRenderScale;
        Stream<Poi> poisToRender = Services.Poi.getServicePois();
        poisToRender = Stream.concat(poisToRender, Services.Poi.getCombatPois());
        poisToRender = Stream.concat(poisToRender, ((List)Managers.Feature.getFeatureInstance(MainMapFeature.class).customPois.get()).stream());
        poisToRender = Stream.concat(poisToRender, Services.Poi.getProvidedCustomPois().stream());
        poisToRender = Stream.concat(poisToRender, Models.Marker.getAllPois());
        poisToRender = Stream.concat(poisToRender, this.getMiniPlayerPois((Boolean)this.renderRemotePartyPlayers.get(), (Boolean)this.renderRemoteFriendPlayers.get(), (Boolean)this.renderRemoteGuildPlayers.get()));
        MultiBufferSource.BufferSource bufferSource = McUtils.mc().renderBuffers().bufferSource();
        for (Poi poi : pois = (Poi[])poisToRender.toArray(Poi[]::new)) {
            float dX = ((float)poi.getLocation().getX() - (float)playerX) / zoomRenderScale;
            float dZ = ((float)poi.getLocation().getZ() - (float)playerZ) / zoomRenderScale;
            if (((Boolean)this.followPlayerRotation.get()).booleanValue()) {
                float tempdX = dX * cosRotationRadians - dZ * sinRotationRadians;
                dZ = dX * sinRotationRadians + dZ * cosRotationRadians;
                dX = tempdX;
            }
            float poiRenderX = centerX + dX;
            float poiRenderZ = centerZ + dZ;
            float poiWidth = poi.getWidth(currentZoom, ((Float)this.poiScale.get()).floatValue());
            float poiHeight = poi.getHeight(currentZoom, ((Float)this.poiScale.get()).floatValue());
            BoundingBox box = BoundingBox.centered(poi.getLocation().getX(), poi.getLocation().getZ(), (int)poiWidth, (int)poiHeight);
            if (!BoundingShape.intersects(box, textureBoundingCircle)) continue;
            poi.renderAt(poseStack, (MultiBufferSource)bufferSource, poiRenderX, poiRenderZ, false, ((Float)this.poiScale.get()).floatValue(), currentZoom, zoomLevel, false);
        }
        bufferSource.endBatch();
        List<WaypointPoi> waypointPois = MarkerModel.USER_WAYPOINTS_PROVIDER.getPois().toList();
        for (WaypointPoi waypointPoi : waypointPois) {
            PoiLocation compassLocation = waypointPoi.getLocation();
            if (compassLocation == null) {
                return;
            }
            float compassOffsetX = ((float)compassLocation.getX() - (float)playerX) / zoomRenderScale;
            float compassOffsetZ = ((float)compassLocation.getZ() - (float)playerZ) / zoomRenderScale;
            if (((Boolean)this.followPlayerRotation.get()).booleanValue()) {
                float tempCompassOffsetX = compassOffsetX * cosRotationRadians - compassOffsetZ * sinRotationRadians;
                compassOffsetZ = compassOffsetX * sinRotationRadians + compassOffsetZ * cosRotationRadians;
                compassOffsetX = tempCompassOffsetX;
            }
            float compassSize = (float)Math.max(waypointPoi.getWidth(currentZoom, ((Float)this.poiScale.get()).floatValue()), waypointPoi.getHeight(currentZoom, ((Float)this.poiScale.get()).floatValue())) * 0.8f;
            float compassRenderX = compassOffsetX + centerX;
            float compassRenderZ = compassOffsetZ + centerZ;
            float distance = MathUtils.magnitude(compassOffsetX, compassOffsetZ);
            compassOffsetX /= distance;
            compassOffsetZ /= distance;
            float scaledWidth = width - 2.0f * compassSize;
            float scaledHeight = height - 2.0f * compassSize;
            float toBorderScale = 1.0f;
            if (this.maskType.get() == MapMaskType.RECTANGULAR) {
                toBorderScale = Math.min(scaledWidth / Math.abs(compassOffsetX), scaledHeight / Math.abs(compassOffsetZ)) / 2.0f;
            } else if (this.maskType.get() == MapMaskType.CIRCLE) {
                toBorderScale = scaledWidth / MathUtils.magnitude(compassOffsetX, compassOffsetZ * scaledWidth / scaledHeight) / 2.0f;
            }
            if (toBorderScale < distance) {
                compassRenderX = centerX + compassOffsetX * toBorderScale;
                compassRenderZ = centerZ + compassOffsetZ * toBorderScale;
                float angle = (float)Math.toDegrees(StrictMath.atan2(compassOffsetZ, compassOffsetX)) + 90.0f;
                poseStack.pushPose();
                RenderUtils.rotatePose(poseStack, compassRenderX, compassRenderZ, angle);
                waypointPoi.getPointerPoi().renderAt(poseStack, (MultiBufferSource)bufferSource, compassRenderX, compassRenderZ, false, ((Float)this.poiScale.get()).floatValue(), 1.0f / zoomRenderScale, zoomLevel, false);
                poseStack.popPose();
            } else {
                waypointPoi.renderAt(poseStack, (MultiBufferSource)bufferSource, compassRenderX, compassRenderZ, false, ((Float)this.poiScale.get()).floatValue(), currentZoom, zoomLevel, false);
            }
            bufferSource.endBatch();
            poseStack.pushPose();
            poseStack.translate(centerX, centerZ, 0.0f);
            poseStack.scale(0.8f, 0.8f, 1.0f);
            poseStack.translate(-centerX, -centerZ, 0.0f);
            FontRenderer fontRenderer = FontRenderer.getInstance();
            Font font = fontRenderer.getFont();
            String text = StringUtils.integerToShortString(Math.round(distance * zoomRenderScale)) + "m";
            float w = (float)font.width(text) / 2.0f;
            Objects.requireNonNull(font);
            float h = 9.0f / 2.0f;
            RenderUtils.drawRect(poseStack, new CustomColor(0.0f, 0.0f, 0.0f, 0.7f), compassRenderX - w - 3.0f, compassRenderZ - h - 1.0f, 0.0f, 2.0f * w + 6.0f, 2.0f * h + 1.0f);
            fontRenderer.renderText(poseStack, StyledText.fromString(text), compassRenderX, compassRenderZ - 3.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.TOP, TextShadow.NORMAL);
            poseStack.popPose();
        }
    }

    private Stream<PlayerMiniMapPoi> getMiniPlayerPois(boolean renderRemotePartyPlayers, boolean renderRemoteFriendPlayers, boolean renderRemoteGuildPlayers) {
        return Services.Hades.getHadesUsers().filter(hadesUser -> hadesUser.getRelation() == PlayerRelation.PARTY && renderRemotePartyPlayers || hadesUser.getRelation() == PlayerRelation.FRIEND && renderRemoteFriendPlayers || hadesUser.getRelation() == PlayerRelation.GUILD && renderRemoteGuildPlayers).map(PlayerMiniMapPoi::new);
    }

    private void renderCardinalDirections(PoseStack poseStack, float width, float height, float centerX, float centerZ) {
        float eastDY;
        float eastDX;
        float northDY;
        float northDX;
        if (this.showCompass.get() == CompassRenderType.NONE) {
            return;
        }
        if (((Boolean)this.followPlayerRotation.get()).booleanValue()) {
            float yawRadians = (float)Math.toRadians(McUtils.mc().gameRenderer.getMainCamera().getYRot());
            northDX = (float)StrictMath.sin(yawRadians);
            northDY = (float)StrictMath.cos(yawRadians);
            double toBorderScaleNorth = 1.0;
            if (this.maskType.get() == MapMaskType.RECTANGULAR) {
                toBorderScaleNorth = Math.min(width / Math.abs(northDX), height / Math.abs(northDY)) / 2.0f;
            } else if (this.maskType.get() == MapMaskType.CIRCLE) {
                toBorderScaleNorth = width / MathUtils.magnitude(northDX, northDY * width / height) / 2.0f;
            }
            northDX = (float)((double)northDX * toBorderScaleNorth);
            northDY = (float)((double)northDY * toBorderScaleNorth);
        } else {
            northDX = 0.0f;
            northDY = -height / 2.0f;
        }
        FontRenderer.getInstance().renderText(poseStack, centerX + northDX, centerZ + northDY, new TextRenderTask("N", TextRenderSetting.CENTERED));
        if (this.showCompass.get() == CompassRenderType.NORTH) {
            return;
        }
        if (((Boolean)this.followPlayerRotation.get()).booleanValue()) {
            eastDX = -northDY;
            eastDY = northDX;
            double toBorderScaleEast = 1.0;
            if (this.maskType.get() == MapMaskType.RECTANGULAR) {
                toBorderScaleEast = Math.min(width / Math.abs(northDY), height / Math.abs(northDX)) / 2.0f;
            } else if (this.maskType.get() == MapMaskType.CIRCLE) {
                toBorderScaleEast = width / MathUtils.magnitude(eastDX, eastDY * width / height) / 2.0f;
            }
            eastDX = (float)((double)eastDX * toBorderScaleEast);
            eastDY = (float)((double)eastDY * toBorderScaleEast);
        } else {
            eastDX = width / 2.0f;
            eastDY = 0.0f;
        }
        FontRenderer.getInstance().renderText(poseStack, centerX + eastDX, centerZ + eastDY, new TextRenderTask("E", TextRenderSetting.CENTERED));
        FontRenderer.getInstance().renderText(poseStack, centerX - northDX, centerZ - northDY, new TextRenderTask("S", TextRenderSetting.CENTERED));
        FontRenderer.getInstance().renderText(poseStack, centerX - eastDX, centerZ - eastDY, new TextRenderTask("W", TextRenderSetting.CENTERED));
    }

    private void renderMapBorder(PoseStack poseStack, float renderX, float renderY, float width, float height) {
        Texture texture = ((MapBorderType)((Object)this.borderType.get())).texture();
        int grooves = ((MapBorderType)((Object)this.borderType.get())).groovesSize();
        BorderInfo borderInfo = this.maskType.get() == MapMaskType.CIRCLE ? ((MapBorderType)((Object)this.borderType.get())).circle() : ((MapBorderType)((Object)this.borderType.get())).square();
        int tx1 = borderInfo.tx1();
        int ty1 = borderInfo.ty1();
        int tx2 = borderInfo.tx2();
        int ty2 = borderInfo.ty2();
        float groovesWidth = (float)grooves * width / 130.0f;
        float groovesHeight = (float)grooves * height / 130.0f;
        RenderUtils.drawTexturedRect(poseStack, texture.resource(), renderX - groovesWidth, renderY - groovesHeight, 0.0f, width + 2.0f * groovesWidth, height + 2.0f * groovesHeight, tx1, ty1, tx2 - tx1, ty2 - ty1, texture.width(), texture.height());
    }

    @Override
    protected void onConfigUpdate(Config<?> config) {
        if (config == this.zoomLevel) {
            this.setZoomLevel(((Float)this.zoomLevel.get()).floatValue());
        }
    }

    public static enum UnmappedOption {
        MINIMAP,
        MINIMAP_AND_COORDS,
        NEITHER;

    }

    private static enum MapMaskType {
        RECTANGULAR,
        CIRCLE;

    }

    private static enum MapBorderType {
        GILDED(Texture.GILDED_MAP_TEXTURES, new BorderInfo(0, 262, 262, 524), new BorderInfo(0, 0, 262, 262), 1),
        PAPER(Texture.PAPER_MAP_TEXTURES, new BorderInfo(0, 0, 217, 217), new BorderInfo(0, 217, 217, 438), 3),
        WYNN(Texture.WYNN_MAP_TEXTURES, new BorderInfo(0, 0, 112, 112), new BorderInfo(0, 112, 123, 235), 3);

        private final Texture texture;
        private final BorderInfo square;
        private final BorderInfo circle;
        private final int groovesSize;

        private MapBorderType(Texture texture, BorderInfo square, BorderInfo circle, int groovesSize) {
            this.texture = texture;
            this.square = square;
            this.circle = circle;
            this.groovesSize = groovesSize;
        }

        private Texture texture() {
            return this.texture;
        }

        private int groovesSize() {
            return this.groovesSize;
        }

        private BorderInfo square() {
            return this.square;
        }

        private BorderInfo circle() {
            return this.circle;
        }
    }

    private static enum CompassRenderType {
        NONE,
        NORTH,
        ALL;

    }

    private record BorderInfo(int tx1, int ty1, int tx2, int ty2) {
    }
}

