/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.base.widgets;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.screens.base.widgets.TextInputBoxWidget;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.screens.colorpicker.ColorPickerScreen;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.RenderUtils;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class ColorPickerWidget
extends WynntilsButton {
    private static final List<Component> TOOLTIP = List.of(Component.translatable((String)"screens.wynntils.colorPicker.widgetTooltip"));
    private final TextInputBoxWidget inputWidget;

    public ColorPickerWidget(int x, int y, int width, int height, TextInputBoxWidget inputWidget) {
        super(x, y, width, height, (Component)Component.literal((String)"Color Picker Widget"));
        this.inputWidget = inputWidget;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        RenderUtils.drawRectBorders(poseStack, this.isHovered ? CommonColors.LIGHT_GRAY : CommonColors.GRAY, this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), 1.0f, 2.0f);
        CustomColor value = CustomColor.fromHexString(this.inputWidget.getTextBoxInput());
        RenderUtils.drawRect(poseStack, value, this.getX(), this.getY(), 0.0f, this.width, this.height);
        if (this.isHovered) {
            McUtils.mc().screen.setTooltipForNextRenderPass(Lists.transform(TOOLTIP, Component::getVisualOrderText));
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        McUtils.mc().setScreen(ColorPickerScreen.create(McUtils.mc().screen, this.inputWidget));
        return true;
    }

    public void onPress() {
    }
}

