/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.base.widgets;

import com.google.common.collect.Lists;
import com.wynntils.core.components.Services;
import com.wynntils.screens.base.widgets.BasicTexturedButton;
import com.wynntils.services.itemfilter.type.ItemProviderType;
import com.wynntils.services.itemfilter.type.ItemStatProvider;
import com.wynntils.services.itemfilter.type.StatFilter;
import com.wynntils.services.itemfilter.type.StatFilterFactory;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.ComponentUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ItemSearchHelperWidget
extends BasicTexturedButton {
    private static final int ELEMENTS_PER_PAGE = 4;
    private final List<ItemProviderType> supportedProviderTypes;
    private final List<List<Component>> tooltipPages = new ArrayList<List<Component>>();
    private int page = 0;

    public ItemSearchHelperWidget(int x, int y, int width, int height, Texture texture, boolean scaleTexture, List<ItemProviderType> supportedProviderTypes) {
        super(x, y, width, height, texture, b -> {}, List.of(), scaleTexture);
        this.supportedProviderTypes = supportedProviderTypes;
        this.generateTooltipPages();
    }

    @Override
    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderUtils.drawTexturedRectWithColor(guiGraphics.pose(), Texture.INFO.resource(), this.isHovered ? CommonColors.AQUA : CommonColors.WHITE, this.getX(), this.getY(), 0.0f, this.getWidth(), this.getHeight(), 0, 0, Texture.INFO.width(), Texture.INFO.height(), Texture.INFO.width(), Texture.INFO.height());
        if (this.isHovered) {
            McUtils.mc().screen.setTooltipForNextRenderPass(Lists.transform(this.getTooltipLines(), Component::getVisualOrderText));
        }
    }

    @Override
    public List<Component> getTooltipLines() {
        return this.tooltipPages.get(this.page);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        if (button == 0) {
            this.page = MathUtils.overflowInRange(this.page, -1, 0, this.tooltipPages.size() - 1);
            return true;
        }
        if (button == 1) {
            this.page = MathUtils.overflowInRange(this.page, 1, 0, this.tooltipPages.size() - 1);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void generateTooltipPages() {
        void var6_9;
        ArrayList<MutableComponent> currentTooltip = new ArrayList<MutableComponent>();
        int counter = 0;
        int filterPageCount = 0;
        List<StatFilterFactory<StatFilter<?>>> statFilters = Services.ItemFilter.getStatFilters();
        for (StatFilterFactory<StatFilter<?>> statFilterFactory : statFilters) {
            currentTooltip.add(Component.empty());
            currentTooltip.add(Component.literal((String)(statFilterFactory.getTranslatedName() + ": ")).withStyle(ChatFormatting.YELLOW));
            currentTooltip.add(Component.translatable((String)statFilterFactory.getDescription()).withStyle(ChatFormatting.GRAY));
            currentTooltip.add(Component.translatable((String)statFilterFactory.getUsage()).withStyle(ChatFormatting.GRAY));
            if (++counter != 4) continue;
            this.tooltipPages.add(currentTooltip);
            currentTooltip = new ArrayList();
            counter = 0;
            ++filterPageCount;
        }
        if (counter != 0) {
            this.tooltipPages.add(currentTooltip);
            currentTooltip = new ArrayList();
            ++filterPageCount;
        }
        counter = 0;
        List<ItemStatProvider> itemStatProviders = Services.ItemFilter.getItemStatProviders().stream().filter(itemStatProvider -> itemStatProvider.getFilterTypes().stream().anyMatch(this.supportedProviderTypes::contains)).toList();
        for (ItemStatProvider itemStatProvider2 : itemStatProviders) {
            currentTooltip.add(Component.empty());
            currentTooltip.add(Component.literal((String)(itemStatProvider2.getName() + ": ")).withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)("(" + itemStatProvider2.getType().getSimpleName() + ")")).withStyle(ChatFormatting.GRAY)));
            currentTooltip.add(Component.translatable((String)itemStatProvider2.getDescription()).withStyle(ChatFormatting.GRAY));
            if (++counter != 4) continue;
            this.tooltipPages.add(currentTooltip);
            currentTooltip = new ArrayList();
            counter = 0;
        }
        if (counter != 0) {
            this.tooltipPages.add(currentTooltip);
        }
        boolean bl = false;
        while (var6_9 < this.tooltipPages.size()) {
            List<Component> tooltipPage2 = this.tooltipPages.get((int)var6_9);
            if (var6_9 < filterPageCount) {
                tooltipPage2.addFirst((Component)Component.translatable((String)"screens.wynntils.itemSearchHelperWidget.availableFilters"));
            } else {
                tooltipPage2.addFirst((Component)Component.translatable((String)"screens.wynntils.itemSearchHelperWidget.availableStats"));
            }
            tooltipPage2.add((Component)Component.empty());
            tooltipPage2.add((Component)Component.translatable((String)"screens.wynntils.itemSearchHelperWidget.page", (Object[])new Object[]{(int)(var6_9 + true), this.tooltipPages.size()}).withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.BOLD));
            tooltipPage2.add((Component)Component.literal((String)"(").append((Component)Component.translatable((String)"screens.wynntils.itemSearchHelperWidget.switchPage").append(")")).withStyle(ChatFormatting.GRAY));
            ++var6_9;
        }
        this.tooltipPages.replaceAll(tooltipPage -> ComponentUtils.wrapTooltips(tooltipPage, 200));
    }
}

