/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.base.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.screens.base.WynntilsPagedScreen;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;

public class PageSelectorButton
extends WynntilsButton {
    private static final ResourceLocation BOOK_TURN_PAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"wynntils", (String)"ui.book.turn-page");
    private static final SoundEvent BOOK_TURN_PAGE_SOUND = SoundEvent.createVariableRangeEvent((ResourceLocation)BOOK_TURN_PAGE_ID);
    private final boolean forward;
    private final WynntilsPagedScreen screen;

    public PageSelectorButton(int x, int y, int width, int height, boolean forward, WynntilsPagedScreen screen) {
        super(x, y, width, height, (Component)Component.literal((String)"Page Selector Button"));
        this.forward = forward;
        this.screen = screen;
    }

    public void onPress() {
        if (!this.isValid()) {
            return;
        }
        McUtils.playSoundUI(BOOK_TURN_PAGE_SOUND);
        if (this.forward) {
            this.screen.setCurrentPage(this.screen.getCurrentPage() + 1);
        } else {
            this.screen.setCurrentPage(this.screen.getCurrentPage() - 1);
        }
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Texture arrowTexture;
        PoseStack poseStack = guiGraphics.pose();
        Texture texture = arrowTexture = this.forward ? Texture.FORWARD_ARROW_OFFSET : Texture.BACKWARD_ARROW_OFFSET;
        if (this.isValid() && !this.isHovered) {
            this.drawTexture(poseStack, arrowTexture, arrowTexture.width() / 2);
        } else {
            this.drawTexture(poseStack, arrowTexture, 0);
        }
    }

    private void drawTexture(PoseStack poseStack, Texture texture, int uOffset) {
        RenderUtils.drawTexturedRect(poseStack, texture.resource(), this.getX(), this.getY(), 0.0f, this.width, this.height, uOffset, 0, texture.width() / 2, texture.height(), texture.width(), texture.height());
    }

    private boolean isValid() {
        return this.forward ? this.screen.getCurrentPage() < this.screen.getMaxPage() : this.screen.getCurrentPage() > 0;
    }
}

