/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.base.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.models.activities.type.ActivitySortOrder;
import com.wynntils.screens.base.TooltipProvider;
import com.wynntils.screens.base.widgets.SortableActivityScreen;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class SortOrderWidget
extends WynntilsButton
implements TooltipProvider {
    private final SortableActivityScreen sortableActivityScreen;

    public SortOrderWidget(int x, int y, int width, int height, SortableActivityScreen sortableActivityScreen) {
        super(x, y, width, height, (Component)Component.literal((String)"Sort Order Button"));
        this.sortableActivityScreen = sortableActivityScreen;
    }

    public void onPress() {
        ActivitySortOrder activitySortOrder = this.sortableActivityScreen.getActivitySortOrder();
        ActivitySortOrder[] activitySortOrders = ActivitySortOrder.values();
        ActivitySortOrder newSort = activitySortOrders[(activitySortOrder.ordinal() + 1) % activitySortOrders.length];
        this.sortableActivityScreen.setActivitySortOrder(newSort);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        Texture sortTexture = switch (this.sortableActivityScreen.getActivitySortOrder()) {
            default -> throw new MatchException(null, null);
            case ActivitySortOrder.LEVEL -> Texture.SORT_LEVEL_OFFSET;
            case ActivitySortOrder.DISTANCE -> Texture.SORT_DISTANCE_OFFSET;
            case ActivitySortOrder.ALPHABETIC -> Texture.SORT_ALPHABETICALLY_OFFSET;
        };
        float renderX = this.getX();
        float renderY = this.getY();
        if (this.isHovered) {
            RenderUtils.drawTexturedRect(poseStack, sortTexture.resource(), renderX, renderY, 0.0f, this.width, this.height, 0, sortTexture.height() / 2, sortTexture.width(), sortTexture.height() / 2, sortTexture.width(), sortTexture.height());
        } else {
            RenderUtils.drawTexturedRect(poseStack, sortTexture.resource(), renderX, renderY, 0.0f, this.width, this.height, 0, 0, sortTexture.width(), sortTexture.height() / 2, sortTexture.width(), sortTexture.height());
        }
    }

    @Override
    public List<Component> getTooltipLines() {
        ActivitySortOrder activitySortOrder = this.sortableActivityScreen.getActivitySortOrder();
        return List.of(Component.translatable((String)"screens.wynntils.wynntilsContentBook.sort.%s.name".formatted(activitySortOrder.name().toLowerCase(Locale.ROOT))), Component.translatable((String)"screens.wynntils.wynntilsContentBook.sort.%s.description".formatted(activitySortOrder.name().toLowerCase(Locale.ROOT))));
    }
}

