/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.chattabs.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Services;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.screens.chattabs.ChatTabEditingScreen;
import com.wynntils.services.chat.ChatTab;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class ChatTabButton
extends WynntilsButton {
    private final ChatTab tab;

    public ChatTabButton(int x, int y, int width, int height, ChatTab tab) {
        super(x, y, width, height, (Component)Component.literal((String)"Chat Tab Button"));
        this.tab = tab;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.tab == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        RenderUtils.drawRect(poseStack, CommonColors.BLACK.withAlpha(this.isHovered ? 0.7f : 0.5f), this.getX(), this.getY(), 0.0f, this.width, this.height);
        CustomColor color = this.getTabColor();
        FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString(this.tab.getName()), this.getX() + 1, this.getX() + this.width, this.getY() + 1, this.getY() + this.height, 0.0f, color, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.OUTLINE);
    }

    private CustomColor getTabColor() {
        if (Services.ChatTab.getFocusedTab() == this.tab) {
            return CommonColors.GREEN;
        }
        return Services.ChatTab.hasUnreadMessages(this.tab) ? CommonColors.YELLOW : CommonColors.WHITE;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        if (button == 0) {
            Services.ChatTab.setFocusedTab(this.tab);
        } else if (button == 1) {
            McUtils.mc().setScreen(ChatTabEditingScreen.create(this.tab));
        }
        return false;
    }

    public void onPress() {
    }
}

