/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.colorpicker;

import com.wynntils.core.consumers.screens.WynntilsScreen;
import com.wynntils.screens.base.widgets.TextInputBoxWidget;
import com.wynntils.screens.colorpicker.widgets.AlphaSlider;
import com.wynntils.screens.colorpicker.widgets.HueSlider;
import com.wynntils.screens.colorpicker.widgets.PresetColorButton;
import com.wynntils.screens.colorpicker.widgets.SaturationBrightnessWidget;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public final class ColorPickerScreen
extends WynntilsScreen {
    private static final int ROW_LIMIT = 10;
    private static final List<CustomColor> PRESET_COLORS = List.of(CommonColors.BLACK, CommonColors.RED, CommonColors.GREEN, CommonColors.BLUE, CommonColors.YELLOW, CommonColors.BROWN, CommonColors.PURPLE, CommonColors.CYAN, CommonColors.AQUA, CommonColors.DARK_AQUA, CommonColors.LIGHT_GRAY, CommonColors.GRAY, CommonColors.DARK_GRAY, CommonColors.TITLE_GRAY, CommonColors.PINK, CommonColors.LIGHT_GREEN, CommonColors.LIGHT_BLUE, CommonColors.MAGENTA, CommonColors.ORANGE, CommonColors.WHITE);
    private final Screen previousScreen;
    private final TextInputBoxWidget inputWidget;
    private AlphaSlider alphaSlider;
    private HueSlider hueSlider;
    private SaturationBrightnessWidget saturationBrightnessWidget;
    private TextInputBoxWidget colorInput;
    private CustomColor color;
    private float hue;
    private float saturation;
    private float brightness;
    private int offsetX;
    private int offsetY;

    private ColorPickerScreen(Screen previousScreen, TextInputBoxWidget inputWidget) {
        super((Component)Component.literal((String)"Color Picker Screen"));
        this.previousScreen = previousScreen;
        this.inputWidget = inputWidget;
        this.color = CustomColor.fromHexString(inputWidget.getTextBoxInput());
    }

    public static Screen create(Screen previousScreen, TextInputBoxWidget inputWidget) {
        return new ColorPickerScreen(previousScreen, inputWidget);
    }

    @Override
    protected void doInit() {
        this.offsetX = (this.width - Texture.COLOR_PICKER_BACKGROUND.width()) / 2;
        this.offsetY = (this.height - Texture.COLOR_PICKER_BACKGROUND.height()) / 2;
        this.saturationBrightnessWidget = new SaturationBrightnessWidget(this.offsetX + 109, this.offsetY + 15, 322, 82, this, this.color);
        this.addRenderableWidget((GuiEventListener)this.saturationBrightnessWidget);
        float[] hsbValues = this.color.asHSB();
        this.hue = hsbValues[0];
        this.saturation = hsbValues[1];
        this.brightness = hsbValues[2];
        this.hueSlider = new HueSlider(this.offsetX + 11, this.offsetY + 105, 420, 20, this.hue, this);
        this.addRenderableWidget((GuiEventListener)this.hueSlider);
        this.alphaSlider = new AlphaSlider(this.offsetX + 11, this.offsetY + 133, 420, 20, (double)this.color.a() / 255.0, this);
        this.addRenderableWidget((GuiEventListener)this.alphaSlider);
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"screens.wynntils.colorPicker.cancel"), button -> this.onClose()).pos(this.offsetX + 40, this.offsetY + Texture.COLOR_PICKER_BACKGROUND.height() + 5).size(150, 20).build());
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"screens.wynntils.colorPicker.save"), button -> {
            this.inputWidget.setTextBoxInput(this.color.toHexString());
            this.onClose();
        }).pos(this.offsetX + Texture.COLOR_PICKER_BACKGROUND.width() - 190, this.offsetY + Texture.COLOR_PICKER_BACKGROUND.height() + 5).size(150, 20).build());
        this.colorInput = new TextInputBoxWidget(this.offsetX + 11, this.offsetY + 84, 60, 18, null, this);
        this.colorInput.setTextBoxInput(this.color.toHexString());
        this.addRenderableWidget((GuiEventListener)this.colorInput);
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)"\u2714").withStyle(ChatFormatting.GREEN), button -> this.applyColor()).pos(this.offsetX + 74, this.offsetY + 83).size(20, 20).build());
        int x = 107;
        int y = 161;
        for (int i = 0; i < PRESET_COLORS.size(); ++i) {
            this.addRenderableWidget((GuiEventListener)new PresetColorButton(this.offsetX + x, this.offsetY + y, 12, 12, PRESET_COLORS.get(i), this));
            x += 24;
            if ((i + 1) % 10 != 0) continue;
            x = 107;
            y += 20;
        }
    }

    public void onClose() {
        McUtils.mc().setScreen(this.previousScreen);
    }

    @Override
    public void doRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        RenderUtils.drawTexturedRect(guiGraphics.pose(), Texture.COLOR_PICKER_BACKGROUND, this.offsetX, this.offsetY);
        this.renderSelectedColor(guiGraphics, this.offsetX + 11, this.offsetY + 15);
        this.renderables.forEach(widget -> widget.render(guiGraphics, mouseX, mouseY, partialTick));
    }

    public void setSaturation(float saturation) {
        this.saturation = saturation;
        this.color = CustomColor.fromHSV(this.hue, saturation, this.brightness, (float)this.color.a() / 255.0f);
        this.colorInput.setTextBoxInput(this.color.toHexString());
    }

    public void setBrightness(float brightness) {
        this.brightness = brightness;
        this.color = CustomColor.fromHSV(this.hue, this.saturation, brightness, (float)this.color.a() / 255.0f);
        this.colorInput.setTextBoxInput(this.color.toHexString());
    }

    public void setHue(float hue) {
        this.hue = hue;
        float[] hsbColor = this.color.asHSB();
        this.color = CustomColor.fromHSV(hue, hsbColor[1], hsbColor[2], (float)this.color.a() / 255.0f);
        this.saturationBrightnessWidget.setColor(CustomColor.fromHSV(hue, 1.0f, 1.0f, (float)this.color.a() / 255.0f));
        this.colorInput.setTextBoxInput(this.color.toHexString());
    }

    public void setAlpha(int alpha) {
        this.color = this.color.withAlpha(alpha);
        this.colorInput.setTextBoxInput(this.color.toHexString());
    }

    public void setColor(CustomColor color) {
        this.color = color;
        this.colorInput.setTextBoxInput(color.toHexString());
        float[] hsbColor = color.asHSB();
        this.hue = hsbColor[0];
        this.saturation = hsbColor[1];
        this.brightness = hsbColor[2];
        this.hueSlider.setValue(this.hue);
        this.saturationBrightnessWidget.setColor(CustomColor.fromHSV(this.hue, 1.0f, 1.0f, (float)color.a() / 255.0f));
        this.saturationBrightnessWidget.updateCursor(this.saturation, this.brightness);
        this.alphaSlider.setValue((double)color.a() / 255.0);
    }

    public CustomColor getColor() {
        return this.color;
    }

    private void applyColor() {
        CustomColor newColor = CustomColor.fromHexString(this.colorInput.getTextBoxInput());
        if (newColor == CustomColor.NONE) {
            return;
        }
        this.setColor(newColor);
    }

    private void renderSelectedColor(GuiGraphics guiGraphics, int x, int y) {
        RenderUtils.drawRect(guiGraphics.pose(), this.color, x, y, 0.0f, 82.0f, 66.0f);
    }
}

