/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.container.widgets;

import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.features.inventory.PersonalStorageUtilitiesFeature;
import com.wynntils.mc.extension.ScreenExtension;
import com.wynntils.models.containers.containers.personal.PersonalStorageContainer;
import com.wynntils.screens.base.widgets.TextInputBoxWidget;
import com.wynntils.screens.container.widgets.PersonalStorageEditNameButton;
import com.wynntils.screens.container.widgets.QuickJumpButton;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;

public class PersonalStorageUtilitiesWidget
extends AbstractWidget {
    private static final int BUTTON_SPACING = 18;
    private final PersonalStorageContainer container;
    private final List<QuickJumpButton> quickJumpButtons = new ArrayList<QuickJumpButton>();
    private final PersonalStorageEditNameButton editButton;
    private final TextInputBoxWidget editInput;
    private final PersonalStorageUtilitiesFeature feature;
    private final AbstractContainerScreen<?> screen;
    private String pageName;

    public PersonalStorageUtilitiesWidget(int x, int y, PersonalStorageContainer container, PersonalStorageUtilitiesFeature feature, AbstractContainerScreen<?> screen) {
        super(x, y, 100, 110, (Component)Component.literal((String)"Personal Storage Utilities Widget"));
        this.container = container;
        this.feature = feature;
        this.screen = screen;
        this.editButton = new PersonalStorageEditNameButton(x + 86, y + 9, 14, 14, this);
        int n = this.getX() + 2;
        int n2 = this.getY() + 10;
        int n3 = this.getWidth() - 18;
        Objects.requireNonNull(FontRenderer.getInstance().getFont());
        this.editInput = new TextInputBoxWidget(n, n2, n3, 9 + 2, null, (ScreenExtension)screen);
        this.editInput.setTextBoxInput(Models.Bank.getPageName(Models.Bank.getCurrentPage()));
        this.editInput.visible = false;
        screen.addRenderableWidget((GuiEventListener)this.editInput);
        this.updatePageName();
        this.addJumpButtons();
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderUtils.drawTexturedRect(guiGraphics.pose(), Texture.BANK_PANEL, this.getX(), this.getY());
        if (!Models.Bank.isEditingName()) {
            FontRenderer.getInstance().renderScrollingText(guiGraphics.pose(), StyledText.fromString(this.pageName), this.getX() + 4, this.getY() + 11, this.getWidth() - 18, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL, 1.0f);
        }
        this.editButton.render(guiGraphics, mouseX, mouseY, partialTick);
        this.editInput.render(guiGraphics, mouseX, mouseY, partialTick);
        this.quickJumpButtons.forEach(button -> button.render(guiGraphics, mouseX, mouseY, partialTick));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        for (GuiEventListener guiEventListener : this.quickJumpButtons) {
            if (!guiEventListener.isMouseOver(mouseX, mouseY)) continue;
            return guiEventListener.mouseClicked(mouseX, mouseY, button);
        }
        if (this.editButton.isMouseOver(mouseX, mouseY)) {
            return this.editButton.mouseClicked(mouseX, mouseY, button);
        }
        return false;
    }

    public void jumpToPage(int destination) {
        this.toggleEditInput(false);
        this.feature.jumpToDestination(destination);
    }

    public void toggleEditInput(boolean visible) {
        this.editInput.visible = visible;
        this.editInput.setTextBoxInput(Models.Bank.getPageName(Models.Bank.getCurrentPage()));
        Models.Bank.toggleEditingName(visible);
    }

    public void updatePageName() {
        this.pageName = Models.Bank.getPageName(Models.Bank.getCurrentPage());
    }

    public String getName() {
        return this.editInput.getTextBoxInput();
    }

    private void addJumpButtons() {
        int renderX = this.getX() + 6;
        int renderY = this.getY() + 23;
        for (int i = 0; i < this.container.getFinalPage(); ++i) {
            this.quickJumpButtons.add(new QuickJumpButton(renderX, renderY, i + 1, this.feature.getLockedQuickJumpColor(), this.feature.getSelectedQuickJumpColor(), this));
            renderX += 18;
            if ((i + 1) % 5 != 0) continue;
            renderX = this.getX() + 6;
            renderY += 18;
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

