/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.guides;

import com.wynntils.core.WynntilsMod;
import com.wynntils.screens.base.WynntilsListScreen;
import com.wynntils.screens.base.widgets.BackButton;
import com.wynntils.screens.base.widgets.ItemFilterUIButton;
import com.wynntils.screens.base.widgets.ItemSearchWidget;
import com.wynntils.screens.base.widgets.PageSelectorButton;
import com.wynntils.screens.base.widgets.SearchWidget;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.screens.guides.WynntilsGuidesListScreen;
import com.wynntils.screens.guides.widgets.filters.FavoriteFilterWidget;
import com.wynntils.screens.guides.widgets.filters.GuideFilterWidget;
import com.wynntils.screens.guides.widgets.sorts.GuideSortButton;
import com.wynntils.screens.guides.widgets.sorts.GuideSortWidget;
import com.wynntils.services.itemfilter.statproviders.LevelStatProvider;
import com.wynntils.services.itemfilter.type.ItemProviderType;
import com.wynntils.services.itemfilter.type.ItemSearchQuery;
import com.wynntils.utils.render.Texture;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;

public abstract class WynntilsGuideScreen<E, B extends WynntilsButton>
extends WynntilsListScreen<E, B> {
    protected final List<GuideFilterWidget> guideFilterWidgets = new ArrayList<GuideFilterWidget>();
    private final List<ItemProviderType> supportedProviderTypes;
    protected GuideSortWidget guideSortWidget;

    protected WynntilsGuideScreen(Component component, List<ItemProviderType> supportedProviderTypes) {
        super(component);
        this.supportedProviderTypes = supportedProviderTypes;
        this.originalSearchWidgetX = 0;
        this.originalSearchWidgetY = -22;
        this.searchWidget = new ItemSearchWidget(this.originalSearchWidgetX, this.originalSearchWidgetY, Texture.CONTENT_BOOK_BACKGROUND.width() - 24, 20, supportedProviderTypes, true, q -> this.reloadElements(), this);
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.addRenderableWidget((GuiEventListener)new ItemFilterUIButton(Texture.CONTENT_BOOK_BACKGROUND.width() - 20 + this.offsetX, -22 + this.offsetY, this.searchWidget, this, true, this.supportedProviderTypes));
        this.addRenderableWidget((GuiEventListener)new BackButton((int)(((float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f - 16.0f) / 2.0f) + this.offsetX, 65 + this.offsetY, Texture.BACK_ARROW_OFFSET.width() / 2, Texture.BACK_ARROW_OFFSET.height(), WynntilsGuidesListScreen.create()));
        this.addRenderableWidget((GuiEventListener)new PageSelectorButton((int)((float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f + 50.0f - (float)Texture.FORWARD_ARROW_OFFSET.width() / 2.0f + (float)this.offsetX), Texture.CONTENT_BOOK_BACKGROUND.height() - 25 + this.offsetY, Texture.FORWARD_ARROW_OFFSET.width() / 2, Texture.FORWARD_ARROW_OFFSET.height(), false, this));
        this.addRenderableWidget((GuiEventListener)new PageSelectorButton(Texture.CONTENT_BOOK_BACKGROUND.width() - 50 + this.offsetX, Texture.CONTENT_BOOK_BACKGROUND.height() - 25 + this.offsetY, Texture.FORWARD_ARROW_OFFSET.width() / 2, Texture.FORWARD_ARROW_OFFSET.height(), true, this));
        this.addDefaultWidgets();
    }

    public void updateSearchFromQuickFilters() {
        SearchWidget searchWidget;
        String filters = this.guideFilterWidgets.stream().map(GuideFilterWidget::getItemSearchQuery).collect(Collectors.joining(" ")).trim();
        String sorts = this.guideSortWidget.getSortQuery().trim();
        String plainQuery = "";
        if (this.searchWidget != null && (searchWidget = this.searchWidget) instanceof ItemSearchWidget) {
            ItemSearchWidget itemSearchWidget = (ItemSearchWidget)searchWidget;
            plainQuery = String.join((CharSequence)" ", itemSearchWidget.getSearchQuery().plainTextTokens()).trim();
        }
        this.searchWidget.setTextBoxInput((plainQuery + " " + filters + " " + sorts).trim().replace("  ", " "));
    }

    protected void addDefaultWidgets() {
        SearchWidget searchWidget = this.searchWidget;
        if (searchWidget instanceof ItemSearchWidget) {
            ItemSearchWidget itemSearchWidget = (ItemSearchWidget)searchWidget;
            this.guideFilterWidgets.clear();
            this.guideFilterWidgets.add((GuideFilterWidget)this.addRenderableWidget((GuiEventListener)new FavoriteFilterWidget((int)((float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f - 24.0f) + this.offsetX, 61 + this.offsetY, this, itemSearchWidget.getSearchQuery())));
            this.guideSortWidget = (GuideSortWidget)this.addRenderableWidget((GuiEventListener)new GuideSortWidget(13 + this.offsetX, 171 + this.offsetY));
            this.guideSortWidget.setPrimarySortButton(new GuideSortButton(itemSearchWidget.getSearchQuery(), this, LevelStatProvider.class));
        } else {
            WynntilsMod.error("WynntilsGuideScreen's SearchWidget is not an ItemSearchWidget");
        }
    }

    @Override
    protected final void reloadElementsList(String ignored) {
        SearchWidget searchWidget = this.searchWidget;
        if (!(searchWidget instanceof ItemSearchWidget)) {
            WynntilsMod.error("WynntilsGuideScreen#reloadElementsList was called with a search widget that is not an ItemSearchWidget");
            return;
        }
        ItemSearchWidget itemSearchWidget = (ItemSearchWidget)searchWidget;
        this.reloadElementsList(itemSearchWidget.getSearchQuery());
    }

    protected abstract void reloadElementsList(ItemSearchQuery var1);
}

