/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.guides.aspect;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.aspects.type.AspectInfo;
import com.wynntils.screens.base.widgets.ItemSearchWidget;
import com.wynntils.screens.base.widgets.SearchWidget;
import com.wynntils.screens.guides.WynntilsGuideScreen;
import com.wynntils.screens.guides.aspect.GuideAspectItemStack;
import com.wynntils.screens.guides.aspect.GuideAspectItemStackButton;
import com.wynntils.screens.guides.widgets.filters.ClassTypeFilterWidget;
import com.wynntils.screens.guides.widgets.filters.FavoriteFilterWidget;
import com.wynntils.screens.guides.widgets.filters.GuideFilterWidget;
import com.wynntils.screens.guides.widgets.filters.RarityFilterWidget;
import com.wynntils.screens.guides.widgets.sorts.GuideSortButton;
import com.wynntils.screens.guides.widgets.sorts.GuideSortWidget;
import com.wynntils.services.itemfilter.statproviders.RarityStatProvider;
import com.wynntils.services.itemfilter.statproviders.TierStatProvider;
import com.wynntils.services.itemfilter.type.ItemProviderType;
import com.wynntils.services.itemfilter.type.ItemSearchQuery;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public final class WynntilsAspectGuideScreen
extends WynntilsGuideScreen<GuideAspectItemStack, GuideAspectItemStackButton> {
    private static final int ELEMENTS_COLUMNS = 7;
    private static final int ELEMENT_ROWS = 7;
    private List<GuideAspectItemStack> allAspectItems = List.of();

    private WynntilsAspectGuideScreen() {
        super((Component)Component.translatable((String)"screens.wynntils.wynntilsGuides.aspectGuide.name"), List.of(ItemProviderType.GENERIC, ItemProviderType.GEAR, ItemProviderType.TIERED));
    }

    public static Screen create() {
        return new WynntilsAspectGuideScreen();
    }

    @Override
    protected void doInit() {
        super.doInit();
        SearchWidget searchWidget = this.searchWidget;
        if (searchWidget instanceof ItemSearchWidget) {
            ItemSearchWidget itemSearchWidget = (ItemSearchWidget)searchWidget;
            this.guideFilterWidgets.add((GuideFilterWidget)this.addRenderableWidget((GuiEventListener)new ClassTypeFilterWidget(19 + this.offsetX, 81 + this.offsetY, this, itemSearchWidget.getSearchQuery())));
            this.guideFilterWidgets.add((GuideFilterWidget)this.addRenderableWidget((GuiEventListener)new RarityFilterWidget(19 + this.offsetX, 101 + this.offsetY, this, itemSearchWidget.getSearchQuery())));
            this.guideSortWidget.setPrimarySortButton(new GuideSortButton(itemSearchWidget.getSearchQuery(), this, TierStatProvider.class));
            this.guideSortWidget.setSecondarySortButton(new GuideSortButton(itemSearchWidget.getSearchQuery(), this, RarityStatProvider.class));
        } else {
            WynntilsMod.error("WynntilsAspectGuideScreen's SearchWidget is not an ItemSearchWidget");
        }
    }

    @Override
    public void doRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        this.renderBackgroundTexture(poseStack);
        this.renderTitle(poseStack, I18n.get((String)"screens.wynntils.wynntilsGuides.aspectGuide.name", (Object[])new Object[0]));
        this.renderVersion(poseStack);
        this.renderItemsHeader(poseStack);
        this.renderWidgets(guiGraphics, mouseX, mouseY, partialTick);
        this.renderPageInfo(poseStack, this.currentPage + 1, this.maxPage + 1);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    @Override
    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Renderable renderable = this.hovered;
        if (renderable instanceof GuideAspectItemStackButton) {
            GuideAspectItemStackButton guideAspectItemStackButton = (GuideAspectItemStackButton)renderable;
            guiGraphics.renderTooltip(FontRenderer.getInstance().getFont(), (ItemStack)guideAspectItemStackButton.getItemStack(), mouseX, mouseY);
        }
        super.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void renderItemsHeader(PoseStack poseStack) {
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(I18n.get((String)"screens.wynntils.wynntilsGuides.itemGuide.available", (Object[])new Object[0])), (float)Texture.CONTENT_BOOK_BACKGROUND.width() * 0.75f + (float)this.offsetX, 30 + this.offsetY, CommonColors.BLACK, HorizontalAlignment.CENTER, VerticalAlignment.TOP, TextShadow.NONE);
    }

    @Override
    protected void addDefaultWidgets() {
        SearchWidget searchWidget = this.searchWidget;
        if (searchWidget instanceof ItemSearchWidget) {
            ItemSearchWidget itemSearchWidget = (ItemSearchWidget)searchWidget;
            this.guideFilterWidgets.clear();
            this.guideFilterWidgets.add((GuideFilterWidget)this.addRenderableWidget((GuiEventListener)new FavoriteFilterWidget((int)((float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f - 24.0f) + this.offsetX, 61 + this.offsetY, this, itemSearchWidget.getSearchQuery())));
            this.guideSortWidget = (GuideSortWidget)this.addRenderableWidget((GuiEventListener)new GuideSortWidget(13 + this.offsetX, 171 + this.offsetY));
        } else {
            WynntilsMod.error("WynntilsAspectGuideScreen's SearchWidget is not an ItemSearchWidget");
        }
    }

    @Override
    protected GuideAspectItemStackButton getButtonFromElement(int i) {
        int xOffset = i % 7 * 20;
        int yOffset = i % this.getElementsPerPage() / 7 * 20;
        return new GuideAspectItemStackButton(xOffset + Texture.CONTENT_BOOK_BACKGROUND.width() / 2 + 13 + this.offsetX, yOffset + 43 + this.offsetY, 18, 18, (GuideAspectItemStack)((Object)this.elements.get(i)), this);
    }

    @Override
    protected void reloadElementsList(ItemSearchQuery searchQuery) {
        this.elements.addAll(Services.ItemFilter.filterAndSort(searchQuery, this.getAllAspectItems()));
        this.guideFilterWidgets.forEach(filter -> filter.updateFromQuery(searchQuery));
        if (this.guideSortWidget == null) {
            return;
        }
        this.guideSortWidget.updateFromQuery(searchQuery);
    }

    private List<GuideAspectItemStack> getAllAspectItems() {
        if (this.allAspectItems.isEmpty()) {
            this.allAspectItems = Models.Aspect.getAllAspectInfos().flatMap(aspectInfo -> IntStream.range(0, aspectInfo.effects().size()).mapToObj(tier -> new GuideAspectItemStack((AspectInfo)aspectInfo, tier + 1))).collect(Collectors.toList());
        }
        return this.allAspectItems;
    }

    @Override
    protected int getElementsPerPage() {
        return 49;
    }
}

