/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.guides.powder;

import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.models.elements.type.Powder;
import com.wynntils.models.elements.type.PowderTierInfo;
import com.wynntils.models.items.items.game.PowderItem;
import com.wynntils.screens.guides.GuideItemStack;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;

public final class GuidePowderItemStack
extends GuideItemStack {
    private final int tier;
    private final Powder element;
    private final PowderTierInfo powderTierInfo;
    private final List<Component> generatedTooltip;

    public GuidePowderItemStack(PowderTierInfo powderTierInfo) {
        super(GuidePowderItemStack.getItemStack(powderTierInfo), new PowderItem(powderTierInfo), powderTierInfo.element().getName() + " Powder");
        this.element = powderTierInfo.element();
        this.tier = powderTierInfo.tier();
        this.powderTierInfo = powderTierInfo;
        this.generatedTooltip = this.generateLore();
    }

    public Component getHoverName() {
        return Component.empty().withStyle(Style.EMPTY.withColor(this.element.getLightColor())).append((Component)Component.literal((String)String.valueOf(this.element.getSymbol())).withStyle(Style.EMPTY.withFont(ResourceLocation.withDefaultNamespace((String)"common")))).append((Component)Component.literal((String)(" " + this.element.getName() + " Powder " + MathUtils.toRoman(this.tier))));
    }

    public List<Component> getTooltipLines(Item.TooltipContext context, Player player, TooltipFlag flag) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add(this.getHoverName());
        tooltip.addAll(this.generatedTooltip);
        tooltip.add((Component)Component.empty());
        if (Services.Favorites.isFavorite(this)) {
            tooltip.add((Component)Component.translatable((String)"screens.wynntils.wynntilsGuides.itemGuide.unfavorite").withStyle(ChatFormatting.YELLOW));
        } else {
            tooltip.add((Component)Component.translatable((String)"screens.wynntils.wynntilsGuides.itemGuide.favorite").withStyle(ChatFormatting.GREEN));
        }
        return tooltip;
    }

    private List<Component> generateLore() {
        ArrayList<Component> itemLore = new ArrayList<Component>();
        String tierStringBuilder = String.valueOf(this.element.getDarkColor()) + "\u25a0".repeat(Math.max(0, this.tier)) + String.valueOf(ChatFormatting.DARK_GRAY) + "\u25a0".repeat(Math.max(0, 6 - this.tier));
        String name = this.element.getName();
        Powder opposingElement = Models.Element.getOpposingElement(this.element);
        itemLore.add((Component)Component.literal((String)("Tier " + this.tier + " [")).withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)tierStringBuilder)).append((Component)Component.literal((String)"]").withStyle(ChatFormatting.GRAY)));
        itemLore.add((Component)Component.empty());
        itemLore.add((Component)Component.literal((String)"Effect on Weapons:").withStyle(this.element.getDarkColor()));
        itemLore.add((Component)Component.empty().append((Component)Component.literal((String)(String.valueOf(this.element.getDarkColor()) + "\u2014 " + String.valueOf(ChatFormatting.GRAY) + "+" + this.powderTierInfo.min() + "-" + this.powderTierInfo.max() + " " + String.valueOf(this.element.getLightColor())))).append((Component)Component.literal((String)String.valueOf(this.element.getSymbol())).withStyle(Style.EMPTY.withFont(ResourceLocation.withDefaultNamespace((String)"common")).withColor(this.element.getLightColor()))).append((Component)Component.literal((String)(String.valueOf(this.element.getLightColor()) + " " + name + " " + String.valueOf(ChatFormatting.GRAY) + "Damage"))));
        itemLore.add((Component)Component.empty().append((Component)Component.literal((String)(String.valueOf(this.element.getDarkColor()) + "\u2014 " + String.valueOf(ChatFormatting.GRAY) + "+" + this.powderTierInfo.convertedFromNeutral() + "% " + String.valueOf(ChatFormatting.GOLD) + "\u2723 Neutral" + String.valueOf(ChatFormatting.GRAY) + " to " + String.valueOf(this.element.getLightColor())))).append((Component)Component.literal((String)String.valueOf(this.element.getSymbol())).withStyle(Style.EMPTY.withFont(ResourceLocation.withDefaultNamespace((String)"common")).withColor(this.element.getLightColor()))).append((Component)Component.literal((String)(String.valueOf(this.element.getLightColor()) + " " + name))));
        itemLore.add((Component)Component.empty());
        itemLore.add((Component)Component.literal((String)"Effect on Armour:").withStyle(this.element.getDarkColor()));
        itemLore.add((Component)Component.empty().append((Component)Component.literal((String)(String.valueOf(this.element.getDarkColor()) + "\u2014 " + String.valueOf(ChatFormatting.GRAY) + "+" + this.powderTierInfo.addedDefence() + " " + String.valueOf(this.element.getLightColor())))).append((Component)Component.literal((String)String.valueOf(this.element.getSymbol())).withStyle(Style.EMPTY.withFont(ResourceLocation.withDefaultNamespace((String)"common")).withColor(this.element.getLightColor()))).append((Component)Component.literal((String)(String.valueOf(this.element.getLightColor()) + " " + name + " " + String.valueOf(ChatFormatting.GRAY) + "Defence"))));
        itemLore.add((Component)Component.empty().append((Component)Component.literal((String)(String.valueOf(this.element.getDarkColor()) + "\u2014 " + String.valueOf(ChatFormatting.GRAY) + "-" + this.powderTierInfo.removedDefence() + " " + String.valueOf(opposingElement.getLightColor())))).append((Component)Component.literal((String)String.valueOf(opposingElement.getSymbol())).withStyle(Style.EMPTY.withFont(ResourceLocation.withDefaultNamespace((String)"common")).withColor(opposingElement.getLightColor()))).append((Component)Component.literal((String)(String.valueOf(opposingElement.getLightColor()) + " " + StringUtils.capitalizeFirst(opposingElement.name().toLowerCase(Locale.ROOT)) + " " + String.valueOf(ChatFormatting.GRAY) + "Defence"))));
        itemLore.add((Component)Component.empty());
        itemLore.add((Component)Component.literal((String)"Add this powder to your items by visiting a Powder Master or use it as an ingredient when crafting.").withStyle(ChatFormatting.DARK_GRAY));
        if (this.tier > 3) {
            itemLore.add((Component)Component.empty());
            itemLore.add((Component)Component.literal((String)"Adding 2 powders of tier 4-6 at the powder master will unlock a special attack/effect.").withStyle(ChatFormatting.DARK_GRAY));
        }
        return itemLore;
    }

    private static ItemStack getItemStack(PowderTierInfo profile) {
        if (profile.tier() <= 3) {
            return new ItemStack((ItemLike)profile.element().getLowTierItem());
        }
        return new ItemStack((ItemLike)profile.element().getHighTierItem());
    }

    public int getTier() {
        return this.tier;
    }

    public Powder getElement() {
        return this.element;
    }
}

