/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.guides.powder;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Services;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.screens.guides.powder.GuidePowderItemStack;
import com.wynntils.screens.guides.powder.WynntilsPowderGuideScreen;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class GuidePowderItemStackButton
extends WynntilsButton {
    private final GuidePowderItemStack itemStack;

    public GuidePowderItemStackButton(int x, int y, int width, int height, GuidePowderItemStack itemStack, WynntilsPowderGuideScreen screen) {
        super(x, y, width, height, (Component)Component.literal((String)"Guide PowderItemStack Button"));
        this.itemStack = itemStack;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        CustomColor color = this.itemStack.getElement().getColor();
        RenderUtils.drawTexturedRectWithColor(poseStack, Texture.HIGHLIGHT.resource(), color.withAlpha(1.0f), this.getX() - 1, this.getY() - 1, 0.0f, 18.0f, 18.0f, Texture.HIGHLIGHT.width(), Texture.HIGHLIGHT.height());
        RenderUtils.renderItem(guiGraphics, this.itemStack, this.getX(), this.getY());
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 200.0f);
        FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString(MathUtils.toRoman(this.itemStack.getTier())), (float)(this.getX() + 2), (float)(this.getX() + 14), (float)(this.getY() + 8), 0.0f, color, HorizontalAlignment.CENTER, TextShadow.OUTLINE);
        poseStack.popPose();
        if (Services.Favorites.isFavorite(this.itemStack)) {
            RenderUtils.drawScalingTexturedRect(poseStack, Texture.FAVORITE_ICON.resource(), this.getX() + 12, this.getY() - 4, 200.0f, 9.0f, 9.0f, Texture.FAVORITE_ICON.width(), Texture.FAVORITE_ICON.height());
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!KeyboardUtils.isKeyDown(340) && !KeyboardUtils.isKeyDown(344)) {
            return false;
        }
        String unformattedName = StyledText.fromComponent(this.itemStack.getHoverName()).getStringWithoutFormatting();
        if (button == 0) {
            Services.Favorites.toggleFavorite(unformattedName);
        }
        return true;
    }

    public void onPress() {
    }

    public GuidePowderItemStack getItemStack() {
        return this.itemStack;
    }
}

