/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.guides.widgets.sorts;

import com.google.common.collect.Lists;
import com.wynntils.core.components.Services;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.guides.WynntilsGuideScreen;
import com.wynntils.services.itemfilter.type.ItemSearchQuery;
import com.wynntils.services.itemfilter.type.ItemStatProvider;
import com.wynntils.services.itemfilter.type.SortDirection;
import com.wynntils.services.itemfilter.type.SortInfo;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.ComponentUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

public class GuideSortButton
extends AbstractWidget {
    private final WynntilsGuideScreen guideScreen;
    private final ItemStatProvider<?> provider;
    private SortDirection sortDirection = null;

    public GuideSortButton(ItemSearchQuery searchQuery, WynntilsGuideScreen guideScreen, Class<?> clazz) {
        super(0, 0, 64, 16, (Component)Component.empty());
        this.guideScreen = guideScreen;
        this.provider = Services.ItemFilter.getItemStatProviders().stream().filter(clazz::isInstance).findFirst().orElseThrow(() -> new IllegalStateException("No provider of type " + clazz.getSimpleName()));
        this.updateFromQuery(searchQuery);
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderUtils.drawRect(guiGraphics.pose(), CommonColors.BLACK.withAlpha(this.isHovered ? 0.7f : 0.5f), this.getX(), this.getY(), 0.0f, this.getWidth(), this.getHeight());
        FontRenderer.getInstance().renderText(guiGraphics.pose(), StyledText.fromString(this.getSortName()), (float)this.getX() + (float)this.getWidth() / 2.0f, (float)this.getY() + (float)this.getHeight() / 2.0f, this.sortDirection == null ? CommonColors.WHITE : CommonColors.ORANGE, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        if (this.sortDirection != null) {
            FontRenderer.getInstance().renderText(guiGraphics.pose(), StyledText.fromString(this.sortDirection == SortDirection.ASCENDING ? "\u25b2" : "\u25bc"), this.getX() + this.getWidth(), this.getY() - 2, CommonColors.YELLOW, HorizontalAlignment.CENTER, VerticalAlignment.TOP, TextShadow.OUTLINE);
        }
        if (this.isHovered) {
            McUtils.mc().screen.setTooltipForNextRenderPass(Lists.transform(ComponentUtils.wrapTooltips(List.of(Component.translatable((String)"screens.wynntils.wynntilsGuides.sortWidget.tooltip", (Object[])new Object[]{this.getSortName()})), 200), Component::getVisualOrderText));
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 || button == 1) {
            if (this.sortDirection == SortDirection.DESCENDING) {
                this.sortDirection = SortDirection.ASCENDING;
            } else if (this.sortDirection != SortDirection.DESCENDING) {
                this.sortDirection = SortDirection.DESCENDING;
            }
        } else if (button == 2) {
            this.sortDirection = null;
        }
        this.guideScreen.updateSearchFromQuickFilters();
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public final void updateFromQuery(ItemSearchQuery searchQuery) {
        Optional<SortInfo> sortInfoOptional = searchQuery.sorts().stream().filter(sortInfo -> sortInfo.provider() == this.provider).findFirst();
        this.sortDirection = sortInfoOptional.map(SortInfo::direction).orElse(null);
    }

    protected final SortInfo getSortInfo() {
        if (this.sortDirection == null) {
            return null;
        }
        return new SortInfo(this.sortDirection, this.provider);
    }

    private String getSortName() {
        return this.provider.getDisplayName();
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

