/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.guildlog;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.consumers.screens.WynntilsScreen;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.wrappedscreen.WrappedScreen;
import com.wynntils.handlers.wrappedscreen.type.WrappedScreenInfo;
import com.wynntils.models.guild.type.GuildLogType;
import com.wynntils.models.items.items.gui.GuildLogItem;
import com.wynntils.screens.base.widgets.BasicTexturedButton;
import com.wynntils.screens.guildlog.GuildLogHolder;
import com.wynntils.screens.guildlog.widgets.LogButton;
import com.wynntils.screens.guildlog.widgets.LogDateWidget;
import com.wynntils.screens.guildlog.widgets.LogEntryWidget;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.ComponentUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.wynn.ContainerUtils;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class GuildLogScreen
extends WynntilsScreen
implements WrappedScreen {
    private static final float SCROLL_FACTOR = 10.0f;
    private static final int SCROLL_AREA_HEIGHT = 125;
    private List<AbstractWidget> logs = new ArrayList<AbstractWidget>();
    private boolean draggingScroll = false;
    private float scrollY;
    private int scrollOffset = 0;
    private int maxScrollOffset = 0;
    private int offsetX;
    private int offsetY;
    private final WrappedScreenInfo wrappedScreenInfo;
    private final GuildLogHolder holder;

    public GuildLogScreen(WrappedScreenInfo wrappedScreenInfo, GuildLogHolder holder) {
        super((Component)Component.literal((String)"Guild Log"));
        this.wrappedScreenInfo = wrappedScreenInfo;
        this.holder = holder;
    }

    @Override
    protected void doInit() {
        this.offsetX = (this.width - Texture.GUILD_LOG_BACKGROUND.width()) / 2;
        this.offsetY = (this.height - Texture.GUILD_LOG_BACKGROUND.height()) / 2;
        this.addRenderableWidget((GuiEventListener)new BasicTexturedButton(this.offsetX + 4, this.offsetY + 2, Texture.LOG_BACK.width(), Texture.LOG_BACK.height(), Texture.LOG_BACK, button -> ContainerUtils.clickOnSlot(0, this.wrappedScreenInfo.containerId(), button, (List<ItemStack>)this.wrappedScreenInfo.containerMenu().getItems()), List.of(Component.translatable((String)"gui.back").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.BOLD}))));
        for (GuildLogType logType : GuildLogType.values()) {
            this.addRenderableWidget((GuiEventListener)new LogButton(this.offsetX + 9, this.offsetY + 17 + logType.ordinal() * 23, button -> ContainerUtils.clickOnSlot(GuildLogHolder.LOG_SLOTS_MAP.get((Object)logType), this.wrappedScreenInfo.containerId(), button, (List<ItemStack>)this.wrappedScreenInfo.containerMenu().getItems()), ComponentUtils.wrapTooltips(List.of(Component.literal((String)logType.getDisplayName()).withStyle(new ChatFormatting[]{logType.getColor(), ChatFormatting.BOLD}), Component.translatable((String)logType.getTooltipKey()).withStyle(ChatFormatting.GRAY)), 150), logType));
        }
    }

    @Override
    public void doRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        RenderUtils.drawTexturedRect(poseStack, Texture.GUILD_LOG_BACKGROUND, this.offsetX, this.offsetY);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent(this.wrappedScreenInfo.screen().getTitle()), this.offsetX + 20, this.offsetY + 10, CommonColors.TITLE_GRAY, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NONE);
        this.renderLogs(guiGraphics, mouseX, mouseY, partialTick);
        this.renderScroll(poseStack);
        this.renderables.forEach(widget -> widget.render(guiGraphics, mouseX, mouseY, partialTick));
    }

    @Override
    public boolean doMouseClicked(double mouseX, double mouseY, int button) {
        if (!this.draggingScroll && MathUtils.isInside((int)mouseX, (int)mouseY, this.offsetX + 393, this.offsetX + 393 + Texture.SCROLL_BUTTON.width(), (int)this.scrollY, (int)(this.scrollY + (float)Texture.SCROLL_BUTTON.height()))) {
            this.draggingScroll = true;
            return true;
        }
        return super.doMouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.draggingScroll) {
            int scrollAreaStartY = this.offsetY + 15 + 17;
            int scrollAreaHeight = 125 - Texture.SCROLL_BUTTON.height();
            int newOffset = Math.round(MathUtils.map((float)mouseY, scrollAreaStartY, scrollAreaStartY + scrollAreaHeight, 0.0f, this.maxScrollOffset));
            newOffset = Math.max(0, Math.min(newOffset, this.maxScrollOffset));
            this.scroll(newOffset);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.draggingScroll = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        int scrollAmount = (int)(-deltaY * 10.0);
        int newOffset = Math.max(0, Math.min(this.scrollOffset + scrollAmount, this.maxScrollOffset));
        this.scroll(newOffset);
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    public void updateLogItems() {
        this.logs = new ArrayList<AbstractWidget>();
        this.maxScrollOffset = 0;
        LocalDate currentDate = null;
        int renderX = this.offsetX + 108;
        int renderY = this.offsetY + 17;
        for (GuildLogItem logItem : this.holder.guildLogItems) {
            Instant logInstant = logItem.getLogInstant();
            LocalDate logDate = logInstant.atZone(ZoneId.systemDefault()).toLocalDate();
            if (currentDate == null || !logDate.isEqual(currentDate)) {
                currentDate = logDate;
                LogDateWidget dateWidget = new LogDateWidget(renderX, renderY, logInstant);
                this.logs.add(dateWidget);
                dateWidget.visible = renderY <= this.offsetY + 17 + 139;
                renderY += 21;
                this.maxScrollOffset += 21;
            }
            int widgetHeight = Texture.LOG_ENTRY_TOP.height() + Texture.LOG_ENTRY_BOTTOM.height() + (logItem.getLogInfo().size() + 1) * Texture.LOG_ENTRY_MIDDLE.height();
            LogEntryWidget entryWidget = new LogEntryWidget(renderX, renderY, widgetHeight, logItem.getLogInfo(), logInstant);
            this.logs.add(entryWidget);
            entryWidget.visible = renderY <= this.offsetY + 17 + 139;
            renderY += widgetHeight + 1;
            this.maxScrollOffset += widgetHeight + 1;
        }
        this.maxScrollOffset -= 121 + Texture.SCROLL_BUTTON.height();
    }

    private void scroll(int newOffset) {
        this.scrollOffset = newOffset;
        int currentY = this.offsetY + 17;
        for (AbstractWidget widget : this.logs) {
            int newY = currentY - this.scrollOffset;
            widget.setY(newY);
            widget.visible = newY <= this.offsetY + 17 + 139 && newY + widget.getHeight() >= this.offsetY + 17;
            currentY += widget.getHeight() + 1;
        }
    }

    private void renderLogs(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderUtils.enableScissor(guiGraphics, this.offsetX + 108, this.offsetY + 16, Texture.LOG_ENTRY_MIDDLE.width(), 139);
        this.logs.forEach(log -> log.render(guiGraphics, mouseX, mouseY, partialTick));
        RenderUtils.disableScissor(guiGraphics);
    }

    private void renderScroll(PoseStack poseStack) {
        this.scrollY = (float)(this.offsetY + 15) + MathUtils.map(this.scrollOffset, 0.0f, this.maxScrollOffset, 0.0f, 141 - Texture.SCROLL_BUTTON.height());
        RenderUtils.drawTexturedRect(poseStack, Texture.SCROLL_BUTTON, this.offsetX + 393, this.scrollY);
    }

    @Override
    public WrappedScreenInfo getWrappedScreenInfo() {
        return this.wrappedScreenInfo;
    }
}

