/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.itemfilter.widgets;

import com.wynntils.screens.base.widgets.WynntilsCheckbox;
import com.wynntils.screens.itemfilter.widgets.GeneralFilterWidget;
import com.wynntils.screens.itemfilter.widgets.ProviderFilterListWidget;
import com.wynntils.services.itemfilter.filters.BooleanStatFilter;
import com.wynntils.services.itemfilter.type.StatProviderAndFilterPair;
import com.wynntils.utils.type.ConfirmedBoolean;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class BooleanFilterWidget
extends GeneralFilterWidget {
    private final WynntilsCheckbox trueCheckbox;
    private final WynntilsCheckbox falseCheckbox;
    private ConfirmedBoolean state = ConfirmedBoolean.UNCONFIRMED;

    protected BooleanFilterWidget(int x, int y, StatProviderAndFilterPair filterPair, ProviderFilterListWidget parent) {
        super(x, y, 195, 145, (Component)Component.literal((String)"Boolean Filter Widget"), parent);
        this.trueCheckbox = new WynntilsCheckbox(this.getX() + 10, this.getY() + 35, 20, (Component)Component.translatable((String)"screens.wynntils.itemFilter.booleanTrue"), this.state == ConfirmedBoolean.TRUE, 150, (checkbox, b) -> {
            if (b.booleanValue()) {
                this.toggleState(ConfirmedBoolean.TRUE);
            }
        });
        this.falseCheckbox = new WynntilsCheckbox(this.getX() + 10, this.getY() + 90, 20, (Component)Component.translatable((String)"screens.wynntils.itemFilter.booleanFalse"), this.state == ConfirmedBoolean.FALSE, 150, (checkbox, b) -> {
            if (b.booleanValue()) {
                this.toggleState(ConfirmedBoolean.FALSE);
            }
        });
        if (filterPair != null) {
            if (filterPair.statFilter().matches(true)) {
                this.state = ConfirmedBoolean.TRUE;
                this.trueCheckbox.selected = true;
                this.falseCheckbox.selected = false;
            } else if (filterPair.statFilter().matches(false)) {
                this.state = ConfirmedBoolean.FALSE;
                this.trueCheckbox.selected = false;
                this.falseCheckbox.selected = true;
            }
        }
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.trueCheckbox.render(guiGraphics, mouseX, mouseY, partialTick);
        this.falseCheckbox.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.trueCheckbox.isMouseOver(mouseX, mouseY)) {
            return this.trueCheckbox.mouseClicked(mouseX, mouseY, button);
        }
        if (this.falseCheckbox.isMouseOver(mouseX, mouseY)) {
            return this.falseCheckbox.mouseClicked(mouseX, mouseY, button);
        }
        return false;
    }

    @Override
    public void updateY(int y) {
    }

    @Override
    protected StatProviderAndFilterPair getFilterPair() {
        if (this.state == ConfirmedBoolean.UNCONFIRMED) {
            return null;
        }
        BooleanStatFilter statFilter = new BooleanStatFilter.BooleanStatFilterFactory().fromBoolean(this.state == ConfirmedBoolean.TRUE);
        return new StatProviderAndFilterPair<Boolean>(this.parent.getProvider(), statFilter);
    }

    private void toggleState(ConfirmedBoolean newState) {
        if (this.state == newState) {
            this.state = ConfirmedBoolean.UNCONFIRMED;
        } else if (newState == ConfirmedBoolean.TRUE) {
            this.state = ConfirmedBoolean.TRUE;
            this.falseCheckbox.selected = false;
        } else {
            this.state = ConfirmedBoolean.FALSE;
            this.trueCheckbox.selected = false;
        }
        this.parent.updateQuery();
    }
}

