/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.itemfilter.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.itemfilter.ItemFilterScreen;
import com.wynntils.services.itemfilter.type.SortDirection;
import com.wynntils.services.itemfilter.type.SortInfo;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

public class SortWidget
extends AbstractWidget {
    private final ItemFilterScreen filterScreen;
    private final List<Button> buttons = new ArrayList<Button>();
    private SortInfo sortInfo;

    public SortWidget(int x, int y, ItemFilterScreen filterScreen, SortInfo sortInfo) {
        super(x, y, 170, 20, (Component)Component.literal((String)"Sort Widget"));
        this.filterScreen = filterScreen;
        this.sortInfo = sortInfo;
        Button sortButton = new Button.Builder((Component)Component.literal((String)(sortInfo.direction() == SortDirection.DESCENDING ? "v" : "\u028c")), button -> this.toggleSortDirection()).pos(x + this.width - 50, y).size(30, 20).build();
        Button upButton = new Button.Builder((Component)Component.literal((String)"\ud83e\udc1d"), button -> filterScreen.reorderSort(sortInfo, -1)).pos(x + this.width - 20, y).size(10, 20).build();
        Button downButton = new Button.Builder((Component)Component.literal((String)"\ud83e\udc1f"), button -> filterScreen.reorderSort(sortInfo, 1)).pos(x + this.width - 10, y).size(10, 20).build();
        Pair<Boolean, Boolean> canSortMove = filterScreen.canSortMove(sortInfo);
        upButton.active = canSortMove.a();
        downButton.active = canSortMove.b();
        this.buttons.add(sortButton);
        this.buttons.add(upButton);
        this.buttons.add(downButton);
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        RenderUtils.drawRectBorders(poseStack, this.sortInfo.direction() == SortDirection.DESCENDING ? CommonColors.WHITE : CommonColors.BLACK, this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, 1.0f, 1.0f);
        FontRenderer.getInstance().renderScrollingText(poseStack, StyledText.fromString(this.sortInfo.provider().getDisplayName()), this.getX() + 2, (float)this.getY() + (float)this.height / 2.0f, this.width - 54, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 1.0f);
        for (Button button : this.buttons) {
            button.render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (mouseY <= (double)this.filterScreen.getProviderMaskTopY() || mouseY >= (double)this.filterScreen.getProviderMaskBottomY()) {
            return false;
        }
        for (GuiEventListener guiEventListener : this.buttons) {
            if (!guiEventListener.isMouseOver(mouseX, mouseY)) continue;
            return guiEventListener.mouseClicked(mouseX, mouseY, button);
        }
        return false;
    }

    public void setY(int y) {
        super.setY(y);
        for (Button button : this.buttons) {
            button.setY(y);
        }
    }

    private void toggleSortDirection() {
        SortInfo oldSortInfo = this.sortInfo;
        this.sortInfo = new SortInfo(this.sortInfo.direction() == SortDirection.DESCENDING ? SortDirection.ASCENDING : SortDirection.DESCENDING, this.sortInfo.provider());
        this.filterScreen.changeSort(oldSortInfo, this.sortInfo);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

