/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.itemfilter.widgets;

import com.wynntils.screens.base.widgets.TextInputBoxWidget;
import com.wynntils.screens.base.widgets.WynntilsCheckbox;
import com.wynntils.screens.itemfilter.ItemFilterScreen;
import com.wynntils.screens.itemfilter.widgets.GeneralFilterWidget;
import com.wynntils.screens.itemfilter.widgets.ProviderFilterListWidget;
import com.wynntils.services.itemfilter.filters.StringStatFilter;
import com.wynntils.services.itemfilter.type.StatFilter;
import com.wynntils.services.itemfilter.type.StatProviderAndFilterPair;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

public class StringFilterWidget
extends GeneralFilterWidget {
    private final Button removeButton;
    private final TextInputBoxWidget entryInput;
    private final WynntilsCheckbox strictCheckbox;
    private boolean ignoreUpdate = false;

    public StringFilterWidget(int x, int y, int width, int height, StatProviderAndFilterPair filterPair, ProviderFilterListWidget parent, ItemFilterScreen filterScreen) {
        super(x, y, width, height, (Component)Component.literal((String)"String Filter Widget"), parent);
        StatFilter statFilter;
        int inputWidth = width - 77;
        this.entryInput = new TextInputBoxWidget(this.getX(), this.getY(), inputWidth, this.getHeight(), s -> {
            if (this.ignoreUpdate) {
                return;
            }
            parent.updateQuery();
        }, filterScreen);
        boolean strict = false;
        if (filterPair != null && (statFilter = filterPair.statFilter()) instanceof StringStatFilter) {
            StringStatFilter stringStatFilter = (StringStatFilter)statFilter;
            this.ignoreUpdate = true;
            strict = stringStatFilter.isStrict();
            this.entryInput.setTextBoxInput(stringStatFilter.getSearchLiteral());
            this.ignoreUpdate = false;
        }
        this.strictCheckbox = new WynntilsCheckbox(this.getX() + inputWidth + 2, this.getY(), 20, (Component)Component.translatable((String)"screens.wynntils.itemFilter.strict"), strict, 50, (checkbox, bl) -> {
            if (bl.booleanValue()) {
                parent.updateQuery();
            }
        }, List.of(Component.translatable((String)"screens.wynntils.itemFilter.strictTooltip")));
        this.removeButton = new Button.Builder((Component)Component.literal((String)"\ud83d\uddd1"), button -> parent.removeWidget(this)).pos(this.getX() + inputWidth + 54, this.getY()).size(20, 20).build();
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.entryInput.render(guiGraphics, mouseX, mouseY, partialTick);
        this.strictCheckbox.render(guiGraphics, mouseX, mouseY, partialTick);
        this.removeButton.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.entryInput.isMouseOver(mouseX, mouseY)) {
            return this.entryInput.mouseClicked(mouseX, mouseY, button);
        }
        if (this.strictCheckbox.isMouseOver(mouseX, mouseY)) {
            return this.strictCheckbox.mouseClicked(mouseX, mouseY, button);
        }
        if (this.removeButton.isMouseOver(mouseX, mouseY)) {
            return this.removeButton.mouseClicked(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.entryInput.isMouseOver(mouseX, mouseY)) {
            return this.entryInput.mouseReleased(mouseX, mouseY, button);
        }
        if (this.strictCheckbox.isMouseOver(mouseX, mouseY)) {
            return this.strictCheckbox.mouseReleased(mouseX, mouseY, button);
        }
        if (this.removeButton.isMouseOver(mouseX, mouseY)) {
            return this.removeButton.mouseReleased(mouseX, mouseY, button);
        }
        return false;
    }

    @Override
    public void updateY(int y) {
        this.setY(y);
        this.entryInput.setY(y);
        this.strictCheckbox.setY(y);
        this.removeButton.setY(y);
    }

    @Override
    protected StatProviderAndFilterPair getFilterPair() {
        if (this.entryInput.getTextBoxInput().isEmpty()) {
            return null;
        }
        Object input = this.strictCheckbox.selected ? "\"" + this.entryInput.getTextBoxInput() + "\"" : this.entryInput.getTextBoxInput();
        Optional<StringStatFilter> statFilterOpt = new StringStatFilter.StringStatFilterFactory().create((String)input);
        return statFilterOpt.map(stringStatFilter -> new StatProviderAndFilterPair<String>(this.parent.getProvider(), (StatFilter<String>)stringStatFilter)).orElse(null);
    }
}

