/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.itemfilter.widgets.numeric;

import com.wynntils.screens.base.widgets.WynntilsCheckbox;
import com.wynntils.screens.itemfilter.ItemFilterScreen;
import com.wynntils.screens.itemfilter.widgets.ProviderFilterListWidget;
import com.wynntils.screens.itemfilter.widgets.numeric.InequalityNumericFilterWidget;
import com.wynntils.services.itemfilter.filters.PercentageStatFilter;
import com.wynntils.services.itemfilter.filters.RangedStatFilters;
import com.wynntils.services.itemfilter.type.StatFilter;
import com.wynntils.services.itemfilter.type.StatProviderAndFilterPair;
import com.wynntils.services.itemfilter.type.StatValue;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class InequalityStatValueFilterWidget
extends InequalityNumericFilterWidget<StatValue> {
    private final WynntilsCheckbox percentageCheckbox;

    public InequalityStatValueFilterWidget(int x, int y, int width, int height, StatProviderAndFilterPair filterPair, ProviderFilterListWidget parent, ItemFilterScreen filterScreen) {
        super(x, y, width, height, parent, filterScreen);
        StatFilter statFilter;
        boolean percentage = false;
        if (filterPair != null && (statFilter = filterPair.statFilter()) instanceof PercentageStatFilter) {
            PercentageStatFilter percentageStatFilter = (PercentageStatFilter)statFilter;
            percentage = true;
            if (percentageStatFilter.getMin() != Float.MIN_VALUE && percentageStatFilter.getMax() == Float.MAX_VALUE) {
                if (percentageStatFilter.isEqualsInString()) {
                    this.setInequalityType(InequalityNumericFilterWidget.InequalityType.GREATER_THAN_EQUAL);
                    this.setEntryInput(String.valueOf(percentageStatFilter.getMin()));
                } else {
                    this.setInequalityType(InequalityNumericFilterWidget.InequalityType.GREATER_THAN);
                    this.setEntryInput(String.valueOf(percentageStatFilter.getMin() - 1.0f));
                }
            } else if (percentageStatFilter.getMax() != Float.MAX_VALUE && percentageStatFilter.getMin() == Float.MIN_VALUE) {
                if (percentageStatFilter.isEqualsInString()) {
                    this.setInequalityType(InequalityNumericFilterWidget.InequalityType.LESS_THAN_EQUAL);
                    this.setEntryInput(String.valueOf(percentageStatFilter.getMax()));
                } else {
                    this.setInequalityType(InequalityNumericFilterWidget.InequalityType.LESS_THAN);
                    this.setEntryInput(String.valueOf(percentageStatFilter.getMax() + 1.0f));
                }
            }
        } else if (filterPair != null && (statFilter = filterPair.statFilter()) instanceof RangedStatFilters.RangedStatValueStatFilter) {
            RangedStatFilters.RangedStatValueStatFilter statValueStatFilter = (RangedStatFilters.RangedStatValueStatFilter)statFilter;
            if (statValueStatFilter.getMin() != Integer.MIN_VALUE && statValueStatFilter.getMax() == Integer.MAX_VALUE) {
                if (statValueStatFilter.isEqualsInString()) {
                    this.setInequalityType(InequalityNumericFilterWidget.InequalityType.GREATER_THAN_EQUAL);
                    this.setEntryInput(String.valueOf(statValueStatFilter.getMin()));
                } else {
                    this.setInequalityType(InequalityNumericFilterWidget.InequalityType.GREATER_THAN);
                    this.setEntryInput(String.valueOf(statValueStatFilter.getMin() - 1));
                }
            } else if (statValueStatFilter.getMax() != Integer.MAX_VALUE && statValueStatFilter.getMin() == Integer.MIN_VALUE) {
                if (statValueStatFilter.isEqualsInString()) {
                    this.setInequalityType(InequalityNumericFilterWidget.InequalityType.LESS_THAN_EQUAL);
                    this.setEntryInput(String.valueOf(statValueStatFilter.getMax()));
                } else {
                    this.setInequalityType(InequalityNumericFilterWidget.InequalityType.LESS_THAN);
                    this.setEntryInput(String.valueOf(statValueStatFilter.getMax() + 1));
                }
            }
        }
        this.percentageCheckbox = new WynntilsCheckbox(this.getX() + this.getWidth() - 52, this.getY(), 20, (Component)Component.literal((String)"%"), percentage, 10, (checkbox, button) -> parent.updateQuery(), List.of(Component.translatable((String)"screens.wynntils.itemFilter.percentageTooltip")));
    }

    @Override
    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        this.percentageCheckbox.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.percentageCheckbox.isMouseOver(mouseX, mouseY)) {
            return this.percentageCheckbox.mouseClicked(mouseX, mouseY, button);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public void updateY(int y) {
        super.updateY(y);
        this.percentageCheckbox.setY(y);
    }

    @Override
    protected Optional<StatFilter<StatValue>> getInequalityStatFilter(String value, InequalityNumericFilterWidget.InequalityType inequalityType) {
        if (this.percentageCheckbox.selected) {
            return new PercentageStatFilter.PercentageStatFilterFactory().create(inequalityType.getMessage() + value + "%").map(f -> f);
        }
        return new RangedStatFilters.RangedStatValueStatFilter.RangedStatValueStatFilterFactory().create(inequalityType.getMessage() + value).map(f -> f);
    }
}

