/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.itemfilter.widgets.numeric;

import com.wynntils.screens.base.widgets.WynntilsCheckbox;
import com.wynntils.screens.itemfilter.ItemFilterScreen;
import com.wynntils.screens.itemfilter.widgets.ProviderFilterListWidget;
import com.wynntils.screens.itemfilter.widgets.numeric.SingleNumericFilterWidget;
import com.wynntils.services.itemfilter.filters.PercentageStatFilter;
import com.wynntils.services.itemfilter.filters.RangedStatFilters;
import com.wynntils.services.itemfilter.type.StatFilter;
import com.wynntils.services.itemfilter.type.StatProviderAndFilterPair;
import com.wynntils.services.itemfilter.type.StatValue;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class SingleStatValueFilterWidget
extends SingleNumericFilterWidget<StatValue> {
    private final WynntilsCheckbox percentageCheckbox;

    public SingleStatValueFilterWidget(int x, int y, int width, int height, StatProviderAndFilterPair filterPair, ProviderFilterListWidget parent, ItemFilterScreen filterScreen) {
        super(x, y, width, height, parent, filterScreen);
        StatFilter statFilter;
        boolean percentage = false;
        if (filterPair != null && (statFilter = filterPair.statFilter()) instanceof PercentageStatFilter) {
            PercentageStatFilter percentageStatFilter = (PercentageStatFilter)statFilter;
            this.setEntryInput(String.valueOf(percentageStatFilter.getMin()));
            percentage = true;
        } else if (filterPair != null && (statFilter = filterPair.statFilter()) instanceof RangedStatFilters.RangedStatValueStatFilter) {
            RangedStatFilters.RangedStatValueStatFilter statValueStatFilter = (RangedStatFilters.RangedStatValueStatFilter)statFilter;
            this.setEntryInput(statValueStatFilter.asString());
        }
        this.percentageCheckbox = new WynntilsCheckbox(this.getX() + this.getWidth() - 52, this.getY(), 20, (Component)Component.literal((String)"%"), percentage, 10, (checkbox, button) -> parent.updateQuery(), List.of(Component.translatable((String)"screens.wynntils.itemFilter.percentageTooltip")));
    }

    @Override
    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        this.percentageCheckbox.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.percentageCheckbox.isMouseOver(mouseX, mouseY)) {
            return this.percentageCheckbox.mouseClicked(mouseX, mouseY, button);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public void updateY(int y) {
        super.updateY(y);
        this.percentageCheckbox.setY(y);
    }

    @Override
    protected Optional<StatFilter<StatValue>> getSingleStatFilter(String value) {
        if (this.percentageCheckbox.selected) {
            return new PercentageStatFilter.PercentageStatFilterFactory().create(value + "%").map(f -> f);
        }
        return new RangedStatFilters.RangedStatValueStatFilter.RangedStatValueStatFilterFactory().create(value).map(f -> f);
    }
}

