/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.lootrunpaths.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Services;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.screens.lootrunpaths.WynntilsLootrunPathsScreen;
import com.wynntils.screens.maps.MainMapScreen;
import com.wynntils.services.lootrunpaths.LootrunPathInstance;
import com.wynntils.services.lootrunpaths.LootrunPathsService;
import com.wynntils.services.lootrunpaths.type.LootrunPath;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.io.File;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;

public class LootrunPathButton
extends WynntilsButton {
    private static final CustomColor BUTTON_COLOR = new CustomColor(181, 174, 151);
    private static final CustomColor BUTTON_COLOR_HOVERED = new CustomColor(121, 116, 101);
    private static final CustomColor TRACKED_BUTTON_COLOR = new CustomColor(176, 197, 148);
    private static final CustomColor TRACKED_BUTTON_COLOR_HOVERED = new CustomColor(126, 211, 106);
    private final LootrunPathInstance lootrun;
    private final WynntilsLootrunPathsScreen screen;

    public LootrunPathButton(int x, int y, int width, int height, LootrunPathInstance lootrun, WynntilsLootrunPathsScreen screen) {
        super(x, y, width, height, (Component)Component.literal((String)"Lootrun Button"));
        this.lootrun = lootrun;
        this.screen = screen;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        CustomColor backgroundColor = this.getButtonBackgroundColor();
        RenderUtils.drawRect(poseStack, backgroundColor, this.getX(), this.getY(), 0.0f, this.width, this.height);
        FontRenderer.getInstance().renderScrollingText(poseStack, StyledText.fromString(this.lootrun.name()), this.getX() + 2, this.getY() + 1, this.width - 3, CommonColors.BLACK, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NONE, 1.0f);
    }

    private CustomColor getButtonBackgroundColor() {
        if (this.isLoaded()) {
            return this.isHovered ? TRACKED_BUTTON_COLOR_HOVERED : TRACKED_BUTTON_COLOR;
        }
        return this.isHovered ? BUTTON_COLOR_HOVERED : BUTTON_COLOR;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (this.isLoaded()) {
                Services.LootrunPaths.clearCurrentLootrun();
            } else {
                Services.LootrunPaths.tryLoadLootrun(this.lootrun.name());
            }
            return true;
        }
        if (button == 2) {
            Util.getPlatform().openFile(LootrunPathsService.LOOTRUNS);
            return true;
        }
        if (button == 1) {
            if ((KeyboardUtils.isKeyDown(340) || KeyboardUtils.isKeyDown(344)) && !this.isLoaded()) {
                this.tryDeleteLootrun();
                return true;
            }
            LootrunPath path = this.lootrun.path();
            Position start = (Position)path.points().getFirst();
            McUtils.mc().setScreen(MainMapScreen.create((float)start.x(), (float)start.z()));
            return true;
        }
        return true;
    }

    public void onPress() {
    }

    private void tryDeleteLootrun() {
        File file = new File(LootrunPathsService.LOOTRUNS, this.lootrun.name() + ".json");
        file.delete();
        this.screen.reloadElements();
    }

    private boolean isLoaded() {
        LootrunPathInstance currentLootrun = Services.LootrunPaths.getCurrentLootrun();
        return currentLootrun != null && Objects.equals(currentLootrun.name(), this.lootrun.name());
    }

    public LootrunPathInstance getLootrun() {
        return this.lootrun;
    }
}

