/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.maps;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.screens.WynntilsScreen;
import com.wynntils.core.text.StyledText;
import com.wynntils.features.debug.MappingProgressFeature;
import com.wynntils.models.marker.MarkerModel;
import com.wynntils.screens.base.TooltipProvider;
import com.wynntils.services.map.MapTexture;
import com.wynntils.services.map.pois.Poi;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.type.Location;
import com.wynntils.utils.mc.type.PoiLocation;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.MapRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.PointerType;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.BoundingBox;
import com.wynntils.utils.type.BoundingShape;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;

public abstract class AbstractMapScreen
extends WynntilsScreen {
    protected static final MultiBufferSource.BufferSource BUFFER_SOURCE = MultiBufferSource.immediate((ByteBufferBuilder)new ByteBufferBuilder(256));
    protected static final float SCREEN_SIDE_OFFSET = 10.0f;
    protected static final int MAP_CENTER_X = -360;
    protected static final int MAP_CENTER_Z = -3000;
    private static final float BORDER_OFFSET = 6.0f;
    private static final int MAX_X = 1650;
    private static final int MAX_Z = -150;
    private static final int MIN_X = -2400;
    private static final int MIN_Z = -6600;
    private static final int CENTER_ZOOM_LEVEL = 20;
    protected boolean holdingMapKey = false;
    protected boolean firstInit = true;
    protected float renderWidth;
    protected float renderHeight;
    protected float renderX;
    protected float renderY;
    protected float renderedBorderXOffset;
    protected float renderedBorderYOffset;
    protected float mapWidth;
    protected float mapHeight;
    protected float centerX;
    protected float centerZ;
    protected float mapCenterX;
    protected float mapCenterZ;
    protected float zoomLevel = 60.0f;
    protected float zoomRenderScale = MapRenderer.getZoomRenderScaleFromLevel(this.zoomLevel);
    protected Poi hovered = null;

    protected AbstractMapScreen() {
        super((Component)Component.literal((String)"Map"));
        this.centerMapAroundPlayer();
    }

    protected AbstractMapScreen(float mapCenterX, float mapCenterZ) {
        super((Component)Component.literal((String)"Map"));
        this.updateMapCenter(mapCenterX, mapCenterZ);
    }

    @Override
    protected void doInit() {
        Options options = McUtils.options();
        KeyMapping.set((InputConstants.Key)options.keyUp.key, (boolean)KeyboardUtils.isKeyDown(options.keyUp.key.getValue()));
        KeyMapping.set((InputConstants.Key)options.keyDown.key, (boolean)KeyboardUtils.isKeyDown(options.keyDown.key.getValue()));
        KeyMapping.set((InputConstants.Key)options.keyLeft.key, (boolean)KeyboardUtils.isKeyDown(options.keyLeft.key.getValue()));
        KeyMapping.set((InputConstants.Key)options.keyRight.key, (boolean)KeyboardUtils.isKeyDown(options.keyRight.key.getValue()));
        KeyMapping.set((InputConstants.Key)options.keyJump.key, (boolean)KeyboardUtils.isKeyDown(options.keyJump.key.getValue()));
        KeyMapping.set((InputConstants.Key)options.keyShift.key, (boolean)KeyboardUtils.isKeyDown(options.keyShift.key.getValue()));
        this.renderWidth = (float)this.width - 20.0f;
        this.renderHeight = (float)this.height - 20.0f;
        this.renderX = 10.0f;
        this.renderY = 10.0f;
        float borderScaleX = (float)this.width / (float)Texture.FULLSCREEN_MAP_BORDER.width();
        float borderScaleY = (float)this.height / (float)Texture.FULLSCREEN_MAP_BORDER.height();
        this.renderedBorderXOffset = 6.0f * borderScaleX;
        this.renderedBorderYOffset = 6.0f * borderScaleY;
        this.mapWidth = this.renderWidth - this.renderedBorderXOffset * 2.0f;
        this.mapHeight = this.renderHeight - this.renderedBorderYOffset * 2.0f;
        this.centerX = this.renderX + this.renderedBorderXOffset + this.mapWidth / 2.0f;
        this.centerZ = this.renderY + this.renderedBorderYOffset + this.mapHeight / 2.0f;
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        for (GuiEventListener child : this.children) {
            if (!(child instanceof TooltipProvider)) continue;
            TooltipProvider tooltipProvider = (TooltipProvider)child;
            if (!child.isMouseOver((double)mouseX, (double)mouseY)) continue;
            guiGraphics.renderComponentTooltip(FontRenderer.getInstance().getFont(), tooltipProvider.getTooltipLines(), mouseX, mouseY);
            return;
        }
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        RenderUtils.drawScalingTexturedRect(poseStack, Texture.FULLSCREEN_MAP_BORDER.resource(), this.renderX, this.renderY, 100.0f, this.renderWidth, this.renderHeight, Texture.FULLSCREEN_MAP_BORDER.width(), Texture.FULLSCREEN_MAP_BORDER.height());
    }

    protected void renderPois(List<Poi> pois, PoseStack poseStack, BoundingBox textureBoundingBox, float poiScale, int mouseX, int mouseY) {
        this.hovered = null;
        List<Poi> filteredPois = this.getRenderedPois(pois, textureBoundingBox, poiScale, mouseX, mouseY);
        MultiBufferSource.BufferSource bufferSource = McUtils.mc().renderBuffers().bufferSource();
        for (int i = filteredPois.size() - 1; i >= 0; --i) {
            Poi poi = filteredPois.get(i);
            float poiRenderX = MapRenderer.getRenderX(poi, this.mapCenterX, this.centerX, this.zoomRenderScale);
            float poiRenderZ = MapRenderer.getRenderZ(poi, this.mapCenterZ, this.centerZ, this.zoomRenderScale);
            poi.renderAt(poseStack, (MultiBufferSource)bufferSource, poiRenderX, poiRenderZ, this.hovered == poi, poiScale, this.zoomRenderScale, this.zoomLevel, true);
        }
        bufferSource.endBatch();
    }

    protected List<Poi> getRenderedPois(List<Poi> pois, BoundingBox textureBoundingBox, float poiScale, int mouseX, int mouseY) {
        ArrayList<Poi> filteredPois = new ArrayList<Poi>();
        for (int i = pois.size() - 1; i >= 0; --i) {
            Poi poi = pois.get(i);
            PoiLocation location = poi.getLocation();
            if (location == null || !poi.isVisible(this.zoomRenderScale, this.zoomLevel)) continue;
            float poiRenderX = MapRenderer.getRenderX(poi, this.mapCenterX, this.centerX, this.zoomRenderScale);
            float poiRenderZ = MapRenderer.getRenderZ(poi, this.mapCenterZ, this.centerZ, this.zoomRenderScale);
            float poiWidth = poi.getWidth(this.zoomRenderScale, poiScale);
            float poiHeight = poi.getHeight(this.zoomRenderScale, poiScale);
            BoundingBox filterBox = BoundingBox.centered(location.getX(), location.getZ(), poiWidth, poiHeight);
            BoundingBox mouseBox = BoundingBox.centered(poiRenderX, poiRenderZ, poiWidth, poiHeight);
            if (!BoundingShape.intersects(filterBox, textureBoundingBox)) continue;
            filteredPois.add(poi);
            if (this.hovered != null || !mouseBox.contains(mouseX, mouseY)) continue;
            this.hovered = poi;
        }
        if (this.hovered != null) {
            filteredPois.remove(this.hovered);
            filteredPois.addFirst(this.hovered);
        }
        return filteredPois;
    }

    protected void setCompassToMouseCoords(double mouseX, double mouseY, boolean removeAll) {
        if (removeAll) {
            MarkerModel.USER_WAYPOINTS_PROVIDER.removeAllLocations();
        }
        double gameX = (mouseX - (double)this.centerX) / (double)this.zoomRenderScale + (double)this.mapCenterX;
        double gameZ = (mouseY - (double)this.centerZ) / (double)this.zoomRenderScale + (double)this.mapCenterZ;
        Location compassLocation = Location.containing(gameX, 0.0, gameZ);
        MarkerModel.USER_WAYPOINTS_PROVIDER.addLocation(compassLocation, null);
        McUtils.playSoundUI(SoundEvents.EXPERIENCE_ORB_PICKUP);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        this.adjustZoomLevel((float)(2.0 * deltaY));
        return true;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.onClose();
            return true;
        }
        if (keyCode == 61 || keyCode == 334) {
            this.adjustZoomLevel(2.0f);
            return true;
        }
        if (keyCode == 45 || keyCode == 333) {
            this.adjustZoomLevel(-2.0f);
            return true;
        }
        InputConstants.Key key = InputConstants.getKey((int)keyCode, (int)scanCode);
        KeyMapping.set((InputConstants.Key)key, (boolean)true);
        return false;
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key key = InputConstants.getKey((int)keyCode, (int)scanCode);
        KeyMapping.set((InputConstants.Key)key, (boolean)false);
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0 && mouseX >= (double)this.renderX && mouseX <= (double)(this.renderX + this.renderWidth) && mouseY >= (double)this.renderY && mouseY <= (double)(this.renderY + this.renderHeight)) {
            this.updateMapCenter((float)((double)this.mapCenterX - dragX / (double)this.zoomRenderScale), (float)((double)this.mapCenterZ - dragY / (double)this.zoomRenderScale));
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    protected void renderCoordinates(PoseStack poseStack, int mouseX, int mouseY) {
        int gameX = (int)(((float)mouseX - this.centerX) / this.zoomRenderScale + this.mapCenterX);
        int gameZ = (int)(((float)mouseY - this.centerZ) / this.zoomRenderScale + this.mapCenterZ);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(gameX + ", " + gameZ), this.centerX, this.renderHeight - this.renderedBorderYOffset - 40.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.TOP, TextShadow.OUTLINE);
    }

    protected void renderZoomWidget(PoseStack poseStack, int mouseX, int mouseY) {
        if (!KeyboardUtils.isShiftDown()) {
            return;
        }
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString("Zoom " + Math.round(this.zoomLevel)), this.renderX + this.renderedBorderXOffset + this.mapWidth - 40.0f, this.renderHeight - this.renderedBorderYOffset - 10.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.TOP, TextShadow.OUTLINE);
    }

    protected void renderMapButtons(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        PoseStack poseStack = guiGraphics.pose();
        RenderUtils.drawTexturedRect(poseStack, Texture.MAP_BUTTONS_BACKGROUND, this.centerX - (float)Texture.MAP_BUTTONS_BACKGROUND.width() / 2.0f, this.renderHeight - this.renderedBorderYOffset - (float)Texture.MAP_BUTTONS_BACKGROUND.height());
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    protected void renderCursor(PoseStack poseStack, float pointerScale, CustomColor pointerColor, PointerType pointerType) {
        double pX = McUtils.player().getX();
        double pZ = McUtils.player().getZ();
        double distanceX = pX - (double)this.mapCenterX;
        double distanceZ = pZ - (double)this.mapCenterZ;
        float cursorX = (float)((double)this.centerX + distanceX * (double)this.zoomRenderScale);
        float cursorZ = (float)((double)this.centerZ + distanceZ * (double)this.zoomRenderScale);
        MapRenderer.renderCursor(poseStack, cursorX, cursorZ, pointerScale, pointerColor, pointerType, false);
    }

    protected void renderMap(GuiGraphics guiGraphics) {
        PoseStack poseStack = guiGraphics.pose();
        RenderUtils.enableScissor(guiGraphics, (int)(this.renderX + this.renderedBorderXOffset), (int)(this.renderY + this.renderedBorderYOffset), (int)this.mapWidth, (int)this.mapHeight);
        RenderUtils.drawRect(poseStack, CommonColors.BLACK, this.renderX + this.renderedBorderXOffset, this.renderY + this.renderedBorderYOffset, 0.0f, this.mapWidth, this.mapHeight);
        BoundingBox textureBoundingBox = BoundingBox.centered(this.mapCenterX, this.mapCenterZ, (float)this.width / this.zoomRenderScale, (float)this.height / this.zoomRenderScale);
        List<MapTexture> maps = Services.Map.getMapsForBoundingBox(textureBoundingBox);
        for (MapTexture map : maps) {
            float textureX = map.getTextureXPosition(this.mapCenterX);
            float textureZ = map.getTextureZPosition(this.mapCenterZ);
            MapRenderer.renderMapQuad(map, poseStack, (MultiBufferSource)BUFFER_SOURCE, this.centerX, this.centerZ, textureX, textureZ, this.mapWidth, this.mapHeight, 1.0f / this.zoomRenderScale);
        }
        BUFFER_SOURCE.endBatch();
        RenderUtils.disableScissor(guiGraphics);
    }

    protected void renderChunkBorders(PoseStack poseStack) {
        BoundingBox textureBoundingBox = BoundingBox.centered(this.mapCenterX, this.mapCenterZ, (float)this.width / this.zoomRenderScale, (float)this.height / this.zoomRenderScale);
        float pX = (float)McUtils.player().getX();
        float pZ = (float)McUtils.player().getZ();
        BoundingBox chunkBoundingBox = KeyboardUtils.isShiftDown() ? textureBoundingBox : BoundingBox.centered(pX, pZ, (Integer)McUtils.options().renderDistance().get() * 16, (Integer)McUtils.options().renderDistance().get() * 16);
        Set<Long> mappedChunks = Managers.Feature.getFeatureInstance(MappingProgressFeature.class).getMappedChunks();
        MapRenderer.renderChunks(poseStack, BUFFER_SOURCE, chunkBoundingBox, mappedChunks, this.mapCenterX, this.centerX, this.mapCenterZ, this.centerZ, this.zoomRenderScale);
    }

    protected void centerMapAroundPlayer() {
        this.updateMapCenter((float)McUtils.player().getX(), (float)McUtils.player().getZ());
    }

    protected void centerMapOnWorld() {
        this.updateMapCenter(-360.0f, -3000.0f);
        this.setZoomLevel(20.0f);
    }

    protected boolean isPlayerInsideMainArea() {
        return MathUtils.isInside((int)McUtils.player().getX(), (int)McUtils.player().getZ(), -2400, 1650, -6600, -150);
    }

    protected void setZoomLevel(float zoomLevel) {
        this.zoomLevel = MathUtils.clamp(zoomLevel, 1.0f, 100.0f);
        this.zoomRenderScale = MapRenderer.getZoomRenderScaleFromLevel(this.zoomLevel);
    }

    private void adjustZoomLevel(float delta) {
        this.setZoomLevel(this.zoomLevel + delta);
    }

    protected void updateMapCenter(float newX, float newZ) {
        this.mapCenterX = newX;
        this.mapCenterZ = newZ;
    }

    public void setHoldingMapKey(boolean holdingMapKey) {
        this.holdingMapKey = holdingMapKey;
    }
}

