/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.maps.widgets;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.marker.MarkerModel;
import com.wynntils.screens.maps.PoiCreationScreen;
import com.wynntils.screens.maps.PoiManagementScreen;
import com.wynntils.services.map.pois.CustomPoi;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;

public class PoiManagerWidget
extends AbstractWidget {
    private final boolean selected;
    private final boolean selectionMode;
    private final Button editButton;
    private final Button deleteButton;
    private final Button upButton;
    private final Button downButton;
    private final Button selectButton;
    private final CustomColor color;
    private final CustomPoi poi;
    private final float dividedWidth;
    private final PoiManagementScreen managementScreen;

    public PoiManagerWidget(int x, int y, int width, int height, CustomPoi poi, PoiManagementScreen managementScreen, float dividedWidth, boolean selectionMode, boolean selected) {
        super(x, y, width, height, (Component)Component.literal((String)poi.getName()));
        this.poi = poi;
        this.managementScreen = managementScreen;
        this.dividedWidth = dividedWidth;
        this.selectionMode = selectionMode;
        this.selected = selected;
        int manageButtonsWidth = (int)(dividedWidth * 4.0f);
        this.color = poi.getVisibility() == CustomPoi.Visibility.HIDDEN ? CommonColors.GRAY : CommonColors.WHITE;
        this.editButton = new Button.Builder((Component)Component.translatable((String)"screens.wynntils.poiManagementGui.edit"), button -> McUtils.mc().setScreen(PoiCreationScreen.create(managementScreen, poi))).pos(x + width - 20 - manageButtonsWidth * 2, y).size(manageButtonsWidth, 20).build();
        this.deleteButton = new Button.Builder((Component)Component.translatable((String)"screens.wynntils.poiManagementGui.delete"), button -> managementScreen.deletePoi(poi, true)).pos(x + width - 20 - manageButtonsWidth, y).size(manageButtonsWidth, 20).build();
        this.upButton = new Button.Builder((Component)Component.literal((String)"\u028c"), button -> managementScreen.updatePoiPosition(poi, -1)).pos(x + width - 20, y).size(10, 20).build();
        this.downButton = new Button.Builder((Component)Component.literal((String)"v"), button -> managementScreen.updatePoiPosition(poi, 1)).pos(x + width - 10, y).size(10, 20).build();
        MutableComponent selectButtonText = selected ? Component.translatable((String)"screens.wynntils.poiManagementGui.deselect") : Component.translatable((String)"screens.wynntils.poiManagementGui.select");
        this.selectButton = new Button.Builder((Component)selectButtonText, button -> managementScreen.selectPoi(poi)).pos(x + width - (manageButtonsWidth * 2 + 20), y).size(manageButtonsWidth * 2 + 20, 20).build();
        List<CustomPoi> pois = managementScreen.getPois();
        if (pois.indexOf(poi) == 0) {
            this.upButton.active = false;
        }
        if (pois.indexOf(poi) == pois.size() - 1) {
            this.downButton.active = false;
        }
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        this.renderIcon(poseStack);
        FontRenderer.getInstance().renderScrollingText(poseStack, StyledText.fromString(this.poi.getName()), this.getX() + (int)(this.dividedWidth * 3.0f), this.getY() + 10, (int)(this.dividedWidth * 15.0f), this.color, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 1.0f);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(String.valueOf(this.poi.getLocation().getX())), this.getX() + (int)(this.dividedWidth * 20.0f), this.getY() + 10, this.color, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        Optional<Integer> poiY = this.poi.getLocation().getY();
        FontRenderer.getInstance().renderText(poseStack, poiY.map(integer -> StyledText.fromString(String.valueOf(integer))).orElse(StyledText.EMPTY), this.getX() + (int)(this.dividedWidth * 23.0f), this.getY() + 10, this.color, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(String.valueOf(this.poi.getLocation().getZ())), this.getX() + (int)(this.dividedWidth * 26.0f), this.getY() + 10, this.color, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        if (this.selectionMode) {
            this.selectButton.render(guiGraphics, mouseX, mouseY, partialTick);
            RenderUtils.drawRectBorders(poseStack, this.selected ? CommonColors.ORANGE : CommonColors.WHITE, this.getX(), this.getY() + 1, this.getX() + this.width, this.getY() + this.height - 1, 0.0f, 1.0f);
        } else {
            this.editButton.render(guiGraphics, mouseX, mouseY, partialTick);
            this.deleteButton.render(guiGraphics, mouseX, mouseY, partialTick);
            this.upButton.render(guiGraphics, mouseX, mouseY, partialTick);
            this.downButton.render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean clickedButton;
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        if (button == 2) {
            McUtils.playSoundUI(SoundEvents.EXPERIENCE_ORB_PICKUP);
            MarkerModel.USER_WAYPOINTS_PROVIDER.addLocation(this.poi.getLocation().asLocation(), this.poi.getIcon(), this.poi.getColor(), this.poi.getColor(), this.poi.getName());
            return true;
        }
        if (button == 1) {
            MarkerModel.USER_WAYPOINTS_PROVIDER.removeLocation(this.poi.getLocation().asLocation());
            return true;
        }
        if (this.selectionMode) {
            clickedButton = this.selectButton.mouseClicked(mouseX, mouseY, button);
        } else {
            boolean bl = clickedButton = this.editButton.mouseClicked(mouseX, mouseY, button) || this.deleteButton.mouseClicked(mouseX, mouseY, button) || this.upButton.mouseClicked(mouseX, mouseY, button) || this.downButton.mouseClicked(mouseX, mouseY, button);
        }
        if (clickedButton) {
            return clickedButton;
        }
        this.managementScreen.selectPoi(this.poi);
        return true;
    }

    private void renderIcon(PoseStack poseStack) {
        float[] poiColor = CustomColor.fromInt(this.poi.getColor().asInt()).asFloatArray();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)poiColor[0], (float)poiColor[1], (float)poiColor[2], (float)1.0f);
        RenderUtils.drawTexturedRect(poseStack, this.poi.getIcon(), (float)this.getX() + this.dividedWidth - (float)this.poi.getIcon().width() / 2.0f, (float)(this.getY() + 10) - (float)this.poi.getIcon().height() / 2.0f);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

