/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.maps.widgets;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.screens.maps.CustomSeaskipperScreen;
import com.wynntils.services.map.pois.SeaskipperDestinationPoi;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class SeaskipperDestinationButton
extends WynntilsButton {
    private final SeaskipperDestinationPoi destination;
    private final CustomSeaskipperScreen seaskipperScreen;

    public SeaskipperDestinationButton(int x, int y, int width, int height, SeaskipperDestinationPoi destination, CustomSeaskipperScreen seaskipperScreen) {
        super(x, y, width, height, (Component)Component.literal((String)"Destination Button"));
        this.destination = destination;
        this.seaskipperScreen = seaskipperScreen;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        RenderUtils.drawTexturedRect(poseStack, Texture.DESTINATION_BUTTON.resource(), this.getX(), this.getY(), 0.0f, this.width, this.height, 0, this.isHovered || this.seaskipperScreen.getSelectedDestination() == this.destination ? Texture.DESTINATION_BUTTON.height() / 2 : 0, Texture.DESTINATION_BUTTON.width(), Texture.DESTINATION_BUTTON.height() / 2, Texture.DESTINATION_BUTTON.width(), Texture.DESTINATION_BUTTON.height());
        float x = (float)this.getX() + (float)this.width * 0.05f;
        float y = (float)this.getY() + (float)this.height * 0.16f;
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.customSeaskipperScreen.destination", (Object[])new Object[]{this.destination.getName(), this.destination.getLevel()})), x, y + 1.0f, CommonColors.BLACK, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NONE, (float)this.height * 0.032f);
        CustomColor priceColor = Models.Emerald.getAmountInInventory() >= this.destination.getDestination().item().getPrice() ? CommonColors.GREEN : CommonColors.RED;
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.customSeaskipperScreen.cost", (Object[])new Object[]{this.destination.getDestination().item().getPrice()})), x, y + 10.0f, priceColor, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.OUTLINE, (float)this.height * 0.032f);
        if (this.isHovered) {
            List<MutableComponent> tooltip = this.seaskipperScreen.getSelectedDestination() == this.destination ? List.of(Component.translatable((String)"screens.wynntils.customSeaskipperScreen.travelToDestination", (Object[])new Object[]{this.destination.getName()}).withStyle(ChatFormatting.GRAY)) : List.of(Component.translatable((String)"screens.wynntils.customSeaskipperScreen.select", (Object[])new Object[]{this.destination.getName()}).withStyle(ChatFormatting.GRAY));
            McUtils.mc().screen.setTooltipForNextRenderPass(Lists.transform(tooltip, Component::getVisualOrderText));
        }
    }

    public void onPress() {
    }

    public SeaskipperDestinationPoi getDestination() {
        return this.destination;
    }
}

