/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.partymanagement;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.WynntilsGridLayoutScreen;
import com.wynntils.screens.base.widgets.InfoButton;
import com.wynntils.screens.base.widgets.TextInputBoxWidget;
import com.wynntils.screens.partymanagement.widgets.CreateLeaveButton;
import com.wynntils.screens.partymanagement.widgets.PartyMemberWidget;
import com.wynntils.screens.partymanagement.widgets.SuggestionPlayerWidget;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;

public final class PartyManagementScreen
extends WynntilsGridLayoutScreen {
    private static final Pattern INVITE_REPLACER = Pattern.compile("[^\\w, ]+");
    private static final Pattern COMMA_REPLACER = Pattern.compile("[,; ]+");
    private static final int START_HEIGHT = 8;
    private static final int PARTY_LIST_DIV_HEIGHT = 14;
    private static final int SUGGESTION_LIST_DIV_HEIGHT = 22;
    private static final int MGMT_ROW_DIV_HEIGHT = 14;
    private int mgmtButtonWidth;
    private TextInputBoxWidget inviteInput;
    private Button inviteButton;
    private Button kickOfflineButton;
    private CreateLeaveButton createLeaveButton;
    private List<SuggestionPlayerWidget> suggestedPlayersWidgets = new ArrayList<SuggestionPlayerWidget>();
    private List<PartyMemberWidget> partyMembersWidgets = new ArrayList<PartyMemberWidget>();

    private PartyManagementScreen() {
        super((Component)Component.literal((String)"Party Management Screen"));
    }

    public static Screen create() {
        return new PartyManagementScreen();
    }

    @Override
    public void doInit() {
        super.doInit();
        this.mgmtButtonWidth = (int)(this.dividedWidth * 8.0f) - 2;
        this.refreshAll();
        this.inviteInput = new TextInputBoxWidget((int)(this.dividedWidth * 36.0f), (int)(this.dividedHeight * 8.0f) + 1, (int)(this.dividedWidth * 57.0f - this.dividedWidth * 36.0f) - 1, 20, null, this, this.inviteInput);
        this.addRenderableWidget((GuiEventListener)this.inviteInput);
        this.inviteButton = new Button.Builder((Component)Component.translatable((String)"screens.wynntils.partyManagementGui.invite"), button -> this.inviteFromField()).pos((int)(this.dividedWidth * 57.0f) + 1, (int)(this.dividedHeight * 8.0f) + 1).size((int)(this.dividedWidth * 3.0f) - 1, 20).build();
        this.addRenderableWidget((GuiEventListener)this.inviteButton);
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"screens.wynntils.partyManagementGui.refreshButton").withStyle(ChatFormatting.GREEN), button -> this.refreshAll()).pos((int)(this.dividedWidth * 36.0f) + 1, (int)(this.dividedHeight * 14.0f)).size(this.mgmtButtonWidth, 20).build());
        this.kickOfflineButton = new Button.Builder((Component)Component.translatable((String)"screens.wynntils.partyManagementGui.kickOfflineButton").withStyle(ChatFormatting.RED), button -> Models.Party.partyKickOffline()).pos((int)(this.dividedWidth * 44.0f) + 1, (int)(this.dividedHeight * 14.0f)).size(this.mgmtButtonWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.kickOfflineButton);
        this.addRenderableWidget((GuiEventListener)new InfoButton((int)(this.dividedWidth * 2.0f), (int)(this.dividedHeight * 58.0f), (Component)Component.literal((String)"").append((Component)Component.translatable((String)"screens.wynntils.partyManagementGui.legend").withStyle(ChatFormatting.UNDERLINE)).append((Component)Component.literal((String)"\n")).append((Component)Component.translatable((String)"screens.wynntils.partyManagementGui.self").withStyle(ChatFormatting.BOLD)).append((Component)Component.literal((String)"\n")).append((Component)Component.translatable((String)"screens.wynntils.partyManagementGui.leader").withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)"\n")).append((Component)Component.translatable((String)"screens.wynntils.partyManagementGui.offline").withStyle(ChatFormatting.STRIKETHROUGH)).append((Component)Component.literal((String)"\n")).append((Component)Component.translatable((String)"screens.wynntils.partyManagementGui.friend").withStyle(ChatFormatting.GREEN))));
    }

    @Override
    public void doRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.doRender(guiGraphics, mouseX, mouseY, partialTick);
        PoseStack poseStack = guiGraphics.pose();
        boolean inParty = Models.Party.isInParty();
        this.createLeaveButton.render(guiGraphics, mouseX, mouseY, partialTick);
        this.kickOfflineButton.active = inParty && !Models.Party.getOfflineMembers().isEmpty() && Models.Party.isPartyLeader(McUtils.playerName());
        this.inviteButton.active = !this.inviteInput.getTextBoxInput().isBlank();
        String inviteFieldHeader = I18n.get((String)"screens.wynntils.partyManagementGui.inviteFieldHeader1", (Object[])new Object[0]) + String.valueOf(ChatFormatting.GRAY) + I18n.get((String)"screens.wynntils.partyManagementGui.inviteFieldHeader2", (Object[])new Object[0]);
        FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString(inviteFieldHeader), this.dividedWidth * 36.0f, this.dividedWidth * 60.0f, this.dividedHeight * 8.0f - FontRenderer.getInstance().calculateRenderHeight(StyledText.fromString(inviteFieldHeader), this.dividedWidth * 24.0f), this.dividedHeight * 8.0f, this.dividedWidth * 24.0f, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL);
        if (inParty) {
            Object[] objectArray = new Object[2];
            objectArray[0] = Models.Party.getPartyMembers().size();
            objectArray[1] = 10;
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(I18n.get((String)"screens.wynntils.partyManagementGui.members", (Object[])objectArray)), this.dividedWidth * 4.0f, this.dividedHeight * 8.0f, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL, 2.0f);
            RenderUtils.drawRect(poseStack, CommonColors.WHITE, this.dividedWidth * 4.0f, this.dividedHeight * 14.0f, 0.0f, this.dividedWidth * 30.0f - this.dividedWidth * 2.0f, 1.0f);
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(I18n.get((String)"screens.wynntils.partyManagementGui.head", (Object[])new Object[0])), this.dividedWidth * 5.0f, this.dividedHeight * 14.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(I18n.get((String)"screens.wynntils.partyManagementGui.name", (Object[])new Object[0])), this.dividedWidth * 7.0f, this.dividedHeight * 14.0f, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(I18n.get((String)"screens.wynntils.partyManagementGui.promote", (Object[])new Object[0])), this.dividedWidth * 22.0f, this.dividedHeight * 14.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(I18n.get((String)"screens.wynntils.partyManagementGui.kick", (Object[])new Object[0])), this.dividedWidth * 26.0f, this.dividedHeight * 14.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(I18n.get((String)"screens.wynntils.partyManagementGui.priority", (Object[])new Object[0])), this.dividedWidth * 30.0f, this.dividedHeight * 14.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
            this.partyMembersWidgets.forEach(widget -> widget.render(guiGraphics, mouseX, mouseY, partialTick));
        } else {
            FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString(I18n.get((String)"screens.wynntils.partyManagementGui.notInParty", (Object[])new Object[0])), this.dividedWidth * 4.0f, this.dividedWidth * 30.0f, this.dividedHeight * 14.0f, (float)this.height - this.dividedHeight * 14.0f, this.dividedWidth * 30.0f - this.dividedWidth * 4.0f, CustomColor.NONE, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 2.0f);
        }
        RenderUtils.drawRect(poseStack, CommonColors.WHITE, this.dividedWidth * 36.0f, this.dividedHeight * 22.0f, 0.0f, this.dividedWidth * 60.0f - this.dividedWidth * 36.0f, 1.0f);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(I18n.get((String)"screens.wynntils.partyManagementGui.head", (Object[])new Object[0])), this.dividedWidth * 37.0f, this.dividedHeight * 22.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(I18n.get((String)"screens.wynntils.partyManagementGui.suggestions", (Object[])new Object[0])), this.dividedWidth * 39.0f, this.dividedHeight * 22.0f, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(I18n.get((String)"screens.wynntils.partyManagementGui.invite", (Object[])new Object[0])), this.dividedWidth * 58.0f, this.dividedHeight * 22.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
        this.suggestedPlayersWidgets.forEach(widget -> widget.render(guiGraphics, mouseX, mouseY, partialTick));
    }

    @Override
    public boolean doMouseClicked(double mouseX, double mouseY, int button) {
        if (this.createLeaveButton.isMouseOver(mouseX, mouseY)) {
            return this.createLeaveButton.mouseClicked(mouseX, mouseY, button);
        }
        for (AbstractWidget abstractWidget : this.partyMembersWidgets) {
            if (!abstractWidget.isMouseOver(mouseX, mouseY)) continue;
            return abstractWidget.mouseClicked(mouseX, mouseY, button);
        }
        for (AbstractWidget abstractWidget : this.suggestedPlayersWidgets) {
            if (!abstractWidget.isMouseOver(mouseX, mouseY)) continue;
            return abstractWidget.mouseClicked(mouseX, mouseY, button);
        }
        return super.doMouseClicked(mouseX, mouseY, button);
    }

    public void reloadCreateLeaveButton() {
        this.createLeaveButton = new CreateLeaveButton((int)(this.dividedWidth * 52.0f) + 1, (int)(this.dividedHeight * 14.0f), this.mgmtButtonWidth, 20);
    }

    public void reloadMembersWidgets() {
        this.partyMembersWidgets = new ArrayList<PartyMemberWidget>();
        ArrayList<String> partyMembers = new ArrayList<String>(Models.Party.getPartyMembers());
        for (int i = 0; i < partyMembers.size(); ++i) {
            String playerName = (String)partyMembers.get(i);
            if (playerName == null) continue;
            this.partyMembersWidgets.add(new PartyMemberWidget(this.dividedWidth * 4.0f, this.dividedHeight * 16.0f + (float)(i * 20), (int)(this.dividedWidth * 28.0f) - (int)(this.dividedWidth * 2.0f), 20, playerName, Models.Party.getOfflineMembers().contains(playerName), 26.0f));
        }
    }

    public void reloadSuggestedPlayersWidgets() {
        ArrayList<String> suggestedPlayers = new ArrayList<String>(Models.Friends.getOnlineFriends().keySet());
        suggestedPlayers.removeAll(Models.Party.getPartyMembers());
        suggestedPlayers.sort(String.CASE_INSENSITIVE_ORDER);
        this.suggestedPlayersWidgets = new ArrayList<SuggestionPlayerWidget>();
        for (int i = 0; i < suggestedPlayers.size(); ++i) {
            boolean isOffline;
            String playerName = (String)suggestedPlayers.get(i);
            boolean bl = isOffline = !Models.Friends.getOnlineFriends().containsKey(playerName);
            if (playerName == null) continue;
            this.suggestedPlayersWidgets.add(new SuggestionPlayerWidget(this.dividedWidth * 36.0f, this.dividedHeight * (float)(23 + i * 3), (int)(this.dividedWidth * 60.0f - this.dividedWidth * 36.0f), 20, playerName, isOffline, 24.0f));
        }
    }

    private void inviteFromField() {
        String fieldText = INVITE_REPLACER.matcher(this.inviteInput.getTextBoxInput()).replaceAll("");
        if ((fieldText = COMMA_REPLACER.matcher(fieldText).replaceAll(",")).isBlank()) {
            return;
        }
        HashSet<String> toInvite = new HashSet<String>(List.of(fieldText.split(",")));
        toInvite.removeAll(Models.Party.getPartyMembers());
        toInvite.forEach(Models.Party::partyInvite);
        this.inviteInput.setTextBoxInput("");
    }

    private void refreshAll() {
        Models.Party.requestData();
        Models.Friends.requestData();
        this.reloadCreateLeaveButton();
        this.reloadMembersWidgets();
        this.reloadSuggestedPlayersWidgets();
    }
}

