/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.partymanagement.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.RenderUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public abstract class AbstractPlayerListEntryWidget
extends AbstractWidget {
    protected final String playerName;
    protected final boolean isOffline;
    protected final float gridDivisions;

    protected AbstractPlayerListEntryWidget(int x, int y, int width, int height, String playerName, boolean isOffline, float gridDivisions) {
        super(x, y, width, height, (Component)Component.literal((String)playerName));
        this.playerName = playerName;
        this.isOffline = false;
        this.gridDivisions = gridDivisions;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        PlayerInfo playerInfo = McUtils.mc().getConnection().getPlayerInfo(this.playerName);
        ResourceLocation skin = playerInfo == null ? DefaultPlayerSkin.getDefaultTexture() : playerInfo.getSkin().texture();
        RenderUtils.drawTexturedRect(poseStack, skin, (float)this.getX() + (float)this.width / this.gridDivisions - 8.0f, this.getY() + this.height / 2 - 8, 8.0f, 16.0f, 16.0f, 8, 8, 8, 8, 64, 64);
        RenderUtils.drawTexturedRect(poseStack, skin, (float)this.getX() + (float)this.width / this.gridDivisions - 8.0f, this.getY() + this.height / 2 - 8, 8.0f, 16.0f, 16.0f, 40, 8, 8, 8, 64, 64);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

